;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_OUTPUT_INFO
;
; Purpose     :	Allows user to change parameters in output_info.
;
; Explanation : Allows user to change parameters in output_info.
;
; Use         : < output_info = rcs_get_output_info(output_info, GROUP_LEADER=group_leader)
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : GSEOS.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 19/1/00
;-
;**********************************************************

PRO rcs_get_output_info_event, event

  COMMON rcs_get_output_info_local, o_info

  ; only one event = 'DONE'

  WIDGET_CONTROL, event.id, GET_UVALUE=info

  ; get output_info

  WIDGET_CONTROL, info, GET_VALUE=o_info

  ; kill widget

  WIDGET_CONTROL, event.top, /DESTROY

END

FUNCTION rcs_get_output_info, output_info, GROUP_LEADER=group_leader

  COMMON rcs_get_output_info_local, o_info

  ; get default output_info

  IF NOT KEYWORD_SET(output_info) THEN output_info = rcs_output_info()

  ; rcs_plot frame

  IF KEYWORD_SET(group_leader) THEN BEGIN

    base = WIDGET_BASE ( TITLE='SET PLOT PARAMETERS', /COL, /FRAME, /MODAL, GROUP_lEADER=group_leader)

  ENDIF ELSE BEGIN

    base = WIDGET_BASE ( TITLE='SET PLOT PARAMETERS', /COL, /FRAME)

  ENDELSE

  ; info display

  info = rcs_cw_info(base,/PARAMETERS)

  dummy = WIDGET_BUTTON(base,VALUE='DONE',UVALUE=info)

  ; realize the widget

  WIDGET_CONTROL, base, /REALIZE

  ; set values

  WIDGET_CONTROL, info, SET_VALUE=output_info

  ; start processing events

  XMANAGER, 'rcs_get_output_info', base

  RETURN, o_info

END
