;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IES_PLOT
;
; Purpose     :	Launches RAPID COMMISSIONING SW WIDGET.
;
; Explanation : Copies intermediate format COMMON block data and then launches RAL IES tool.
;
; Use         : < rcs_ies_plot,  E3DDNM=e3ddnm, EHIST=ehist, E3DDBM=e3ddbm, EPAD=epad, EHK=ehk, NM_CLEAN=nm_clean, BM_CLEAN=bm_clean, $
;                                I3DD_H=i3ddh, I3DDHE=i3ddhe, I3DDCNO=i3ddcno, IPAD=ipad, HSPCT=hspct, ISPCTHE=ispcthe, $
;                                ISPCTCNO=ispctcno, MTRX=mtrx, SGLBM=sglbm, SGL01=sgl01, SGL2=sgl2, SGL3=sgl3, $
;                                HK1=hk1, HK2=hk2, HK4=hk4, HK8=hk8, HK32=hk32, SCINFO=scinfo >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : Selects data from respective COMMON block.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestal
;               Version 0.2, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 08/02/02
;                 Added EPAD2.
;               Version 0.4, 24/09/03
;                 Changed initialization of draw widget block.
;
; Version     :	Version 0.4, 24/09/03
;-
;**********************************************************

PRO rcs_ies_plot, E3DDNM=e3ddnm, EHIST=ehist, E3DDBM=e3ddbm, EPAD=epad, E2PAD=e2pad, EHK=ehk, $
   NM_CLEAN=nm_clean, BM_CLEAN=bm_clean, BM2_CLEAN=bm2_clean, PEDESTALS=pedestals, ESPCT=espct, $
   I3DD_H=i3ddh, I3DDHE=i3ddhe, I3DDCNO=i3ddcno, IPAD=ipad, HSPCT=hspct, ISPCTHE=ispcthe, $
   ISPCTCNO=ispctcno, MTRX=mtrx, SGLBM=sglbm, SGL01=sgl01, SGL2=sgl2, SGL3=sgl3, $
   HK1=hk1, HK2=hk2, HK4=hk4, HK8=hk8, HK32=hk32, SCINFO=scinfo

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  COMMON ies_getset_block, struct

  ; initialize draw widget COMMON block

  rcs_draw_widget_block, 0, 0, /SET

  ; if struct defined then ies_getset calls ies_bands with /GET_CURRENT
  ; so that energy bands are kept from previous call.
  ; This may give the wrong number of bands so delete struct

  struct = 0

  IF KEYWORD_SET(e3ddnm) THEN BEGIN

     IF KEYWORD_SET(e3ddnm_header) THEN rcs_draw_widget_block, e3ddnm_header, e3ddnm_data, /SET

  ENDIF ELSE IF KEYWORD_SET(ehist) THEN BEGIN

     IF KEYWORD_SET(ehist_header) THEN rcs_draw_widget_block, ehist_header, ehist_data, /SET

  ENDIF ELSE IF KEYWORD_SET(e3ddbm) THEN BEGIN

     IF KEYWORD_SET(e3ddbm_header) THEN rcs_draw_widget_block, e3ddbm_header, e3ddbm_data, /SET

  ENDIF ELSE IF KEYWORD_SET(espct) THEN BEGIN

     IF KEYWORD_SET(espct_header) THEN rcs_draw_widget_block, espct_header, espct_data, /SET

  ENDIF ELSE IF KEYWORD_SET(epad) THEN BEGIN

     IF KEYWORD_SET(epad_header) THEN rcs_draw_widget_block, epad_header, epad_data, /SET

  ENDIF ELSE IF KEYWORD_SET(e2pad) THEN BEGIN

     IF KEYWORD_SET(epad2_header) THEN rcs_draw_widget_block, epad2_header, epad2_data, /SET

  ENDIF ELSE IF KEYWORD_SET(ehk) THEN BEGIN

     IF KEYWORD_SET(ehk_header) THEN rcs_draw_widget_block, ehk_header, ehk_data, /SET

  ENDIF ELSE IF KEYWORD_SET(nm_clean) THEN BEGIN

     IF KEYWORD_SET(clean_header) THEN rcs_draw_widget_block, clean_header, clean_data, /SET

  ENDIF ELSE IF KEYWORD_SET(bm_clean) THEN BEGIN

     IF KEYWORD_SET(cleanbm_header) THEN rcs_draw_widget_block, cleanbm_header, cleanbm_data, /SET

  ENDIF ELSE IF KEYWORD_SET(bm2_clean) THEN BEGIN

     IF KEYWORD_SET(cleanbm2_header) THEN rcs_draw_widget_block, cleanbm2_header, cleanbm2_data, /SET

  ENDIF ELSE IF KEYWORD_SET(pedestals) THEN BEGIN

     IF KEYWORD_SET(pedestal_header) THEN rcs_draw_widget_block, pedestal_header, pedestal_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hk1) THEN BEGIN

     IF KEYWORD_SET(hk1_header) THEN rcs_draw_widget_block, hk1_header, hk1_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hk2) THEN BEGIN

     IF KEYWORD_SET(hk2_header) THEN rcs_draw_widget_block, hk2_header, hk2_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hk4) THEN BEGIN

     IF KEYWORD_SET(hk4_header) THEN rcs_draw_widget_block, hk4_header, hk4_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hk8) THEN BEGIN

     IF KEYWORD_SET(hk8_header) THEN rcs_draw_widget_block, hk8_header, hk8_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hk32) THEN BEGIN

     IF KEYWORD_SET(hk32_header) THEN rcs_draw_widget_block, hk32_header, hk32_data, /SET

  ENDIF ELSE IF KEYWORD_SET(i3ddh) THEN BEGIN

     IF KEYWORD_SET(i3dd_header_H) THEN rcs_draw_widget_block, i3dd_header_H, i3dd_data_H, /SET

  ENDIF ELSE IF KEYWORD_SET(i3ddhe) THEN BEGIN

     IF KEYWORD_SET(i3dd_header_He) THEN rcs_draw_widget_block, i3dd_header_He, i3dd_data_He, /SET

  ENDIF ELSE IF KEYWORD_SET(i3ddcno) THEN BEGIN

     IF KEYWORD_SET(i3dd_header_CNO) THEN rcs_draw_widget_block, i3dd_header_CNO, i3dd_data_CNO, /SET

  ENDIF ELSE IF KEYWORD_SET(ipad) THEN BEGIN

     IF KEYWORD_SET(ipad_header) THEN rcs_draw_widget_block, ipad_header, ipad_data, /SET

  ENDIF ELSE IF KEYWORD_SET(hspct) THEN BEGIN

     IF KEYWORD_SET(hspct_header) THEN rcs_draw_widget_block, hspct_header, hspct_data, /SET

  ENDIF ELSE IF KEYWORD_SET(ispcthe) THEN BEGIN

     IF KEYWORD_SET(ispct_header_He) THEN rcs_draw_widget_block, ispct_header_He, ispct_data_He, /SET

  ENDIF ELSE IF KEYWORD_SET(ispctcno) THEN BEGIN

     IF KEYWORD_SET(ispct_header_CNO) THEN rcs_draw_widget_block, ispct_header_CNO, ispct_data_CNO, /SET

  ENDIF ELSE IF KEYWORD_SET(mtrx) THEN BEGIN

     IF KEYWORD_SET(mtrx_header) THEN rcs_draw_widget_block, mtrx_header, mtrx_data, /SET

  ENDIF ELSE IF KEYWORD_SET(sglbm) THEN BEGIN

     IF KEYWORD_SET(sglbm_header) THEN rcs_draw_widget_block, sglbm_header, sglbm_data, /SET

  ENDIF ELSE IF KEYWORD_SET(sgl01) THEN BEGIN

     IF KEYWORD_SET(sgl01_header) THEN rcs_draw_widget_block, sgl01_header, sgl01_data, /SET

  ENDIF ELSE IF KEYWORD_SET(sgl2) THEN BEGIN

     IF KEYWORD_SET(sgl2_header) THEN rcs_draw_widget_block, sgl2_header, sgl2_data, /SET

  ENDIF ELSE IF KEYWORD_SET(sgl3) THEN BEGIN

     IF KEYWORD_SET(sgl3_header) THEN rcs_draw_widget_block, sgl3_header, sgl3_data, /SET

  ENDIF ELSE IF KEYWORD_SET(scinfo) THEN BEGIN

     IF KEYWORD_SET(scinfo_header) THEN rcs_draw_widget_block, scinfo_header, scinfo_data, /SET

  ENDIF ELSE rcs_message, /IMPLEMENTATION

  ; call ies_plot

  IF KEYWORD_SET(full_header) THEN ies_plot

END
