;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MCP_PLOT
;
; Purpose     :	Produces mcp plot.
;
; Explanation : Produces mcp plot.
;
; Use         : < >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 12/06/01
;
; Modified    :	Version 0.1, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 0.2, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 08/10/03
;-
;**********************************************************

PRO rcs_mcp_plot, sc, WIN=win, PS=ps, PNG=png, GIF=gif, MODE=modelist, $
  MINIMUM=minimum, MAXIMUM=maximum, MCP_PROCESS=mcp_process

  IF NOT (KEYWORD_SET(win) OR KEYWORD_SET(ps) OR KEYWORD_SET(png) OR KEYWORD_SET(gif)) THEN win=1

  IF NOT KEYWORD_SET(psym) THEN psym = 3

  IF NOT KEYWORD_SET(mcp_process) THEN mcp_process = 1

  ; removed  LOADCT, 39 since this is not compatible with batch operation

  sc = rcs_strtrim(sc)

  IF NOT KEYWORD_SET(minimum) THEN minimum = 10

  IF NOT KEYWORD_SET(maximum) THEN maximum = 1e6

  ; check if margins defined

  xmargin = [8,3]

  ymargin = [1.5,0.6]

  mode0 = 0
  mode1 = 0
  mode2 = 0
  mode3 = 0
  mode4 = 0
  mode5 = 0

  RESTORE, concat_dir(concat_dir(ies_get_Dir('IF',/RAPID),'RAPID_'+sc),'mcp_modes'+rcs_strtrim(mcp_process)+'.dat')

  HELP, mode0, mode1, mode2, mode3, mode4, mode5

  tstart = 1.0d10

  IF KEYWORD_SET(mode0) THEN tstart = MIN([tstart,mode0[0].time])

  IF KEYWORD_SET(mode1) THEN tstart = MIN([tstart,mode1[0].time])

  IF KEYWORD_SET(mode2) THEN tstart = MIN([tstart,mode2[0].time])

  IF KEYWORD_SET(mode3) THEN tstart = MIN([tstart,mode3[0].time])

  IF KEYWORD_SET(mode4) THEN tstart = MIN([tstart,mode4[0].time])

  IF KEYWORD_SET(mode5) THEN tstart = MIN([tstart,mode5[0].time])

  tstop = 0.0d0

  IF KEYWORD_SET(mode0) THEN tstop = MAX([tstop,mode0[N_ELEMENTS(mode0)-1].time])

  IF KEYWORD_SET(mode1) THEN tstop = MAX([tstop,mode1[N_ELEMENTS(mode1)-1].time])

  IF KEYWORD_SET(mode2) THEN tstop = MAX([tstop,mode2[N_ELEMENTS(mode2)-1].time])

  IF KEYWORD_SET(mode3) THEN tstop = MAX([tstop,mode3[N_ELEMENTS(mode3)-1].time])

  IF KEYWORD_SET(mode4) THEN tstop = MAX([tstop,mode4[N_ELEMENTS(mode4)-1].time])

  IF KEYWORD_SET(mode5) THEN tstop = MAX([tstop,mode5[N_ELEMENTS(mode5)-1].time])

  CASE mcp_process OF

    1: BEGIN

         modes = ['NM serial', 'BM serial', 'NM parallel', 'BM parallel', 'Sun BM serial', 'Sun BM parallel']

         subtitles = ['STA0-7','STO0-7','STA8-15','STO8-15','STA','STO']

         IF NOT KEYWORD_SET(modelist) THEN modelist = INDGEN(6)

         FOR ww = 0, N_ELEMENTS(modelist)-1 DO BEGIN

           w = modelist[ww]

           CASE w OF
             0 : IF KEYWORD_SET(mode0) THEN mode = mode0 ELSE mode = 0
             1 : IF KEYWORD_SET(mode1) THEN mode = mode1 ELSE mode = 0
             2 : IF KEYWORD_SET(mode2) THEN mode = mode2 ELSE mode = 0
             3 : IF KEYWORD_SET(mode3) THEN mode = mode3 ELSE mode = 0
             4 : IF KEYWORD_SET(mode4) THEN mode = mode4 ELSE mode = 0
             5 : IF KEYWORD_SET(mode5) THEN mode = mode5 ELSE mode = 0
           ENDCASE

           IF KEYWORD_SET(mode) THEN BEGIN

             ; set up output file name

             dir = concat_dir(ies_get_dir('PNG'),rcs_get_scname(sc))

             IF KEYWORD_SET(png) THEN BEGIN

               png = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.png')

             ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

               gif = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.gif')

             ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

               ps = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.ps')

             ENDIF

             info = rcs_start_plot( WIN=win, PS=ps, PNG=png, GIF=gif, HEADING='SC'+sc+' MCP START and STOP counts for '+modes[w])

             FOR k = 0,1+2*(1-(w/4)) DO rcs_plot_panel, mode.time, mode.data[k], info, 4, k, tstart, tstop, minimum, maximum, xmargin, ymargin, $
                 modes[w]+' '+subtitles[k+4*(w/4)], /LOG

             rcs_end_plot, info, /UPDATED

           ENDIF

         ENDFOR

      END

    2: BEGIN

         modes = ['SDIR serial','SDIR Parallel']

         subtitles = ['SDIR-S1','SDIR-S2','SDIR-S3','SDIR-3S']

         IF NOT KEYWORD_SET(modelist) THEN modelist = [0,1]

         FOR ww = 0, N_ELEMENTS(modelist)-1 DO BEGIN

           w = modelist[ww]

           CASE w OF
             0 : IF KEYWORD_SET(mode0) THEN mode = mode0 ELSE mode = 0
             1 : IF KEYWORD_SET(mode2) THEN mode = mode2 ELSE mode = 0
           ENDCASE

           IF KEYWORD_SET(mode) THEN BEGIN

             ; set up output file name

             dir = concat_dir(ies_get_dir('PNG'),rcs_get_scname(sc))

             IF KEYWORD_SET(png) THEN BEGIN

               png = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.png')

             ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

               gif = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.gif')

             ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

               ps = concat_dir ( dir, 'sc' + sc + STRCOMPRESS(modes[w],/REMOVE_ALL) + '.ps')

             ENDIF

             info = rcs_start_plot( WIN=win, PS=ps, PNG=png, GIF=gif, HEADING='SC'+sc+' MCP counts for '+modes[w])

             FOR k = 0,3 DO rcs_plot_panel, mode.time, mode.data[k], info, 4, k, tstart, tstop, minimum, maximum, xmargin, ymargin, $
                 modes[w]+' '+subtitles[k], /LOG

             rcs_end_plot, info, /UPDATED

           ENDIF

         ENDFOR

      END


    ELSE : PRINT, 'INVALID MCP PROCESS'

  ENDCASE

END