;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_OUTPUT_INFO
;
; Purpose     :	Sets up display information structure.
;
; Explanation :	Structure output_info contains information used in the displays.
;               This routine sets up the defaults.
;
; Use         : < output_info = rcs_output_info() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : output_info : STRUCTURE
;
;                 title     : STRING title for panel
;                 timer     : FLOAT event timer period in secs i.e time between plot updates
;                 log       : FLAG log display of counts
;                 nobad     : FLAG data with error flag set not displayed
;                 elog      : FLAG log display of energy
;                 xtitle    : STRING title for time axis
;                 ytitle    : STRING title for energy axis
;                 ztitle    : STRING title for counts axis
;
;                 Following are flags indicating display panels of data required
;                 luts      : FLAG indicating display this data
;                 scflag    : FLAG indicating display this data
;                 hkflag    : FLAG indicating display this data
;                 hv        : FLAG indicating display this data
;                 tmp       : FLAG indicating display this data
;                 espct     : FLAG indicating display this data
;                 hspct     : FLAG indicating display this data
;                 ispctHe   : FLAG indicating display this data
;                 ispctCNO  : FLAG indicating display this data
;                 sglbm     : FLAG indicating display this data
;                 sgl01     : FLAG indicating display this data
;                 sgl1      : FLAG indicating display this data
;                 sgl2      : FLAG indicating display this data
;                 sgl3      : FLAG indicating display this data
;                 i3dd      : FLAG indicating display this data
;                 ipad      : FLAG indicating display this data
;                 clean     : FLAG indicating display this data
;                 cleanbm   : FLAG indicating display this data
;                 cleanbm2   : FLAG indicating display this data
;                 pedestal  : FLAG indicating display this data
;                 m         : FLAG indicating display this data
;                 ehist     : FLAG indicating display this data
;                 fit       : FLAG indicating display this data
;                 e3dd      : FLAG indicating display this data
;                 e3ddbm    : FLAG indicating display this data
;                 epad      : FLAG indicating display this data
;                 epad2     : FLAG indicating display this data
;                 ehk       : FLAG indicating display this data
;                 hkfcr     : FLAG indicating display this data
;                 sta       : FLAG indicating display this data
;                 sto       : FLAG indicating display this data
;                 subc      : FLAG indicating display this data
;                 noutputs  : INT total no of display panels
;
;                 use_dets  : INTARR indicating which detectors for display
;                 use_bmdets: INTARR indicating which detectors for display
;                 use_epad  : INTARR indicating which detectors for display
;                 use_epad2 : INTARR indicating which detectors for display
;                 use_ehk   : INTARR indicating which detectors for display
;                 use_i3dd  : INTARR indicating which detectors for display
;                 use_i3ddm : INTARR indicating which detectors for display
;                 use_ipad  : INTARR indicating which detectors for display
;                 use_ispct : INTARR indicating which detectors for display
;                 use_cleans: INTARR indicating which detectors for display
;                 use_bmcleans: INTARR indicating which detectors for display
;                 use_pedestals: INTARR indicating which detectors for display
;
;                 hist      : FLAG indicating display widget required for this data
;
;                 pre       : FLOAT no of minutes prior to current time for display
;                 post      : FLOAT no of minutes after current time for display
;                 minimum   : FLOAT minimum value for counts axis
;                 maximum   : FLOAT maximum value for counts axis
;                 elow      : FLOAT minimum value for energy axis
;                 ehigh     : FLOAT maximum value for count axis
;                 tmax      : DOUBLE TAI time of last data
;                 tstart    : DOUBLE TAI time of display start
;                 tstop     : DOUBLE TAI time of display stop
;                 cal       : BYTE flag indicating apply geometric factor
;                 div       : BYTE flag indicating divide by energy width
;                 rat       : BYTE flag indicating convert to rate
;                 eff       : BYTE flag indicating apply efficiency
;                 sectors   : BYTE flag indicating display sector plot
;                 fulltime  : BYTE flag indicating display full time range
;                 nohk      : BYTE flag indicating dont display Hk on its own
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 9/2/01
;                 Changed centroid to pedestal.
;                 Added espct.
;               Version 0.2, 16/03/01
;                 Changed SET keyword in ies_ncolors to WYSIWYG.
;               Version 0.3, 15/05/01
;                 Added CLEANBM2.
;               Version 0.4, 25/05/01
;                 Added HKSUN and HKRAT.
;               Version 0.5, 31/05/01
;                 Added STABM and STOBM.
;               Version 0.6, 08/02/02
;                 Added EPAD2.
;               Version 0.7, 10/07/02
;                 Removed ncolors.
;
; Version     :	Version 0.7, 10/07/02
;-
;**********************************************************

FUNCTION rcs_output_info

  ; NB label detectors 0:8

  output_info = {title:'DEFAULT', timer:1.0, log:1, showch:1, nobad:0, elog:0, cal:0, rat:0, eff:0, div:0, sectors:0, fulltime:0, nohk:0, $
                 xtitle:'time', ytitle:'', ztitle:'Counts', noutputs:0, pre:-50.0, post:10.0, $
                 minimum:1.e0, maximum:1.e6, elow:0.0, ehigh:500.0, tmax:0.d0, tstart:0.d0, tstop:0.d0, $
                 use_dets:[0,0,0,0,0,0,0,0,0], use_bmdets:[0,0,0,0,0,0,0,0,0], use_epad:[0,0,0,0,0,0], use_epad2:[0,0,0,0,0,0],use_ehk:[0,0,0,0,0,0,0,0,0],  $
                 use_i3dd:LONARR(12), use_i3ddm:LONARR(3), use_ipad:LONARR(6), use_ispct:LONARR(3), use_cleans:LONARR(9), use_bmcleans:LONARR(9), use_bm2cleans:LONARR(9), use_pedestals:LONARR(9), $
                 i3dd:0, ipad:0, clean:0L, cleanbm:0L, cleanbm2:0L, pedestal:0, espct:0, m:0, $
                 luts:0, scflag:0, hkflag:0, hv:0, tmp:0, hksun:0, hkrat:0, hspct:0, ispctHe:0, ispctCNO:0, sglbm:0, sgl01:0, sgl1:0, sgl2:0, sgl3:0, hist:0, $
                 ehist:0, fit:0, e3dd:0, e3ddbm:0, epad:0, epad2:0, ehk:0, hkfcr:0, sta:0, sto:0, stabm:0, stobm:0, subc:0}

  RETURN, output_info

END
