;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PEDESTAL_PLOT
;
; Purpose     :	Produces pedestal plot.
;
; Explanation : Produces pedestal plot.
;
; Use         : < >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 04/07/01
;
; Modified    :	Version 0.1, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 0.2, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 08/10/03
;-
;**********************************************************

PRO rcs_pedestal_plot, sc, WIN=win, PS=ps, PNG=png, GIF=gif, MINIMUM=minimum, MAXIMUM=maximum, TYPE=type

  IF NOT (KEYWORD_SET(win) OR KEYWORD_SET(ps) OR KEYWORD_SET(png) OR KEYWORD_SET(gif)) THEN win=1

  IF NOT KEYWORD_SET(psym) THEN psym = 3

  ; removed  LOADCT, 39 since this is not compatible with batch operation

  sc = rcs_strtrim(sc)

  IF NOT KEYWORD_SET(minimum) THEN minimum = -5

  IF NOT KEYWORD_SET(maximum) THEN maximum = 5

  ; check if margins defined

  xmargin = [8,3]

  ymargin = [1.5,0.6]

  subtitles = 'Dt '+rcs_strtrim(INDGEN(9))

  peds = 0

  RESTORE, concat_dir(ies_get_dir('IF',/RAPID),'RAPID_'+sc),'peds.dat')

  HELP, peds

  tstart = peds[0].time

  tstop = peds[N_ELEMENTS(peds)-1].time

  IF NOT KEYWORD_SET(type) THEN type = 0

  CASE type OF

    0: BEGIN

         ; set up output file name

         dir = concat_dir(ies_get_dir('PNG',/RAPID),rcs_get_scname(sc))

         IF KEYWORD_SET(png) THEN BEGIN

           png = concat_dir ( dir, 'sc' + sc + '_pedestals.png')

         ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

           gif = concat_dir ( dir, 'sc' + sc + sc + '_pedestals.gif')

         ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

           ps = concat_dir ( dir, 'sc' + sc + sc + '_pedestals.ps')

         ENDIF

         info = rcs_start_plot( WIN=win, PS=ps, PNG=png, GIF=gif, HEADING='SC'+sc+' RAPID/IES PEDESTALS')

         FOR k = 0, 8 DO rcs_plot_panel, peds.time, peds.data[k,1], info, 9, k, tstart, tstop, minimum, maximum, xmargin, ymargin, $
                 subtitles[k], PSYM=psym

         rcs_end_plot, info, /UPDATED

      END

    ELSE : PRINT, 'INVALID TYPE'

  ENDCASE

END