;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_returns
;
; Purpose     :	Deals with errors.
;
; Explanation : Deals with errors in generating plots.
;
; Use         : < res = rcs_returns(file, WINDOWS=windows, PS=postscript, PNG=png, $
;                   GIF=gif, BWPS=bwps, UNFINISHED=unfinished, IOERROR=ioerror, NODATA=nodata >
;
; Inputs      : file   : STRING output filename
;
; Opt. Inputs : None.
;
; Outputs     :res : INT flag indicating success of plot
;                       0 : failed
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;
; Written     :	Version 0.0, 07/02/02
;
; Modified    :	Version 0.1, 16/01/03
;                 Added generation of blank plot.
;
; Version     :	Version 0.1, 16/01/03
;-
;**********************************************************

FUNCTION rcs_returns, devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, UNFINISHED=unfinished, IOERROR=ioerror, NODATA=nodata

  SET_PLOT, devname

  IF KEYWORD_SET(ioerror) THEN BEGIN

    rcs_message, !ERR_STRING, /CONT, /TRACEBACK

    RETURN, 0

  ENDIF ELSE IF KEYWORD_SET(unfinished) THEN BEGIN

    ; set up file name

    IF NOT KEYWORD_SET(file) THEN BEGIN

      IF KEYWORD_SET(ps)  THEN file = ps  ELSE $
      IF KEYWORD_SET(png) THEN file = png ELSE $
      IF KEYWORD_SET(gif) THEN file = gif ELSE $
      IF KEYWORD_SET(bwps) THEN file = bwps $
      ELSE file = ''

    ENDIF

    rcs_text, 'ERROR, PLOT ABANDONED : '+file

    RETURN, 0

  ENDIF ELSE IF KEYWORD_SET(nodata) THEN BEGIN

    ; set up file name

    IF NOT KEYWORD_SET(file) THEN BEGIN

      IF KEYWORD_SET(ps)  THEN file = ps  ELSE $
      IF KEYWORD_SET(png) THEN file = png ELSE $
      IF KEYWORD_SET(gif) THEN file = gif ELSE $
      IF KEYWORD_SET(bwps) THEN file = bwps $
      ELSE file = ''

    ENDIF

    rcs_text, 'WARNING, NO DATA FOR PLOT : '+file

    ; generate blank plot file

    rcs_blank_plot, devname, file, ' NO DATA FOR '+STRMID(strip_dirname(file),0,6), WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps

    RETURN, 0

  ENDIF ELSE RETURN, 0

END
