;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	RCS_SC_PLOT
;
; Purpose     :	Produces sc plot for 4SC survey plot panel.
;
; Explanation : Produces sc plot for 4SC survey plot panel.
;
; Use         : < rcs_sc_plot, ax, ay, COLOR=color >
;
; Inputs      : 
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 15/02/02
;
; Modified    :	
;
; Version     :	Version 0.0, 15/02/02
;-
;**********************************************************

PRO rcs_sc_plot, ax, ay, COLOR=col

  ; doesnt plot ay=0 values for some reason

  list = WHERE(ay EQ 0.0d0, count)

  kpos = 0

  FOR k = 0, count-1 DO BEGIN

    IF list[k] GT kpos THEN OPLOT, [ax[kpos:list[k]-1]], [ay[*,*,kpos:list[k]-1]], PSYM=-3, COLOR=col

    kpos = list[k]+1

  ENDFOR

  IF N_ELEMENTS(ax) GT kpos THEN OPLOT, [ax[kpos:*]], [ay[*,*,kpos:*]], PSYM=-3, COLOR=col

END

