;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	RCS_SET_TIME_RANGE
;
; Purpose     :	Sets plotting time range.
;
; Explanation : Produces 4 spacecraft survey plots.Sets plotting time range.
;
; Use         : < rcs_set_time_range, start_time, end_time>
;
; Inputs      : start_time : STRING day in form yymmdd.
;               end_time   :
;
; Opt. Inputs : None.
;
; Outputs     : start_time : DOUBLE TAI start time of period of interest.
;               end_time   : DOUBLE TAI end   time of period of interest.
;
; Opt. Outputs:	None.
;
; Keywords    : NPLOT      : INT selecting period of day for plot.
;               DAY        : STRING day in format yymmdd
;               TIME_RANGE : [2] any sort of time giving start and stop times of
;                            period of interest
;
; Written     :	Version 0.0, Martin Carter, RAL, 15/02/02
;
; Modified    :	Version 0.1, 01/03/02
;                 Added conversion to TAI time inside routine.
;               Version 0.2, 02/09/03
;                 Used rcs_if_filter.
;               Version 0.3, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.3, 08/10/03
;-
;**********************************************************

PRO rcs_set_time_range, start_time, end_time, NPLOT=nplot, DAY=day, TIME_RANGE=time_range

  ; set up day

  IF KEYWORD_SET(time_range) THEN BEGIN

    start_time = anytim2tai(time_range[0])

    end_time = anytim2tai(time_range[1])

  ENDIF ELSE BEGIN

    IF NOT KEYWORD_SET(day) THEN BEGIN

      tday = ies_pickfile(PATH=ies_get_dir('IF',/RAPID), COUNT=count, TITLE='Select day file',$
                       FILTER=rcs_if_filter(SOURCE=rcs_get_source()) )

      IF count EQ 0 THEN RETURN

      tday = strip_dirname(tday)

      IF STRLEN(tday) LT 6 THEN RETURN

      tday = STRMID(tday,0,6)

    ENDIF ELSE tday = day

    start_time = anytim2tai(STRMID(tday,0,2)+'/'+STRMID(tday,2,2)+'/'+STRMID(tday,4,2))

    IF NOT KEYWORD_SET(nplot) THEN BEGIN

      end_time = start_time+86400

    ENDIF ELSE BEGIN

      end_time = start_time+(86400L/rcs_get_nplots())*nplot

      start_time = start_time + (86400L/rcs_get_nplots())*(nplot-1)

    ENDELSE

  ENDELSE

END
