;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_survey
;
; Purpose     :	Produces survey plots.
;
; Explanation : Produces various survey plots.
;
; Use         : < rcs_survey, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             T0=input_start_time, T1=input_end_time, TYPE=type >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               TYPE        = INT giving type of survey plot required.
;                                0 : IES : panels with spectral plot of detectors and LUT panel
;                                1 : IIMS : panels with spectral plots of detector 6 for each
;                                    H, He, CNO and panels with sector plots of above.
;                                2 : SGL : panels with point plots of STA/STO, ENY/TCR/TAC, HV.
;                                3 : SPCT : panels with spectral plots of HSPCT, ISPCT-He and ISPCT_CNO.
;                                4 : IESBM : panels with IES sector plots.
;                                5 : IES CLEAN : panels with spectral plot of CLEAN detectors and LUT panel
;               T0          = DOUBLE TAI start time
;               T1          = DOUBLE TAI end time
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 13/12/00
;                 Added PNG format.
;                 Changed so that does not crash if IOERROR.
;               Version 0.2, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.3, 14/2/01
;                 Removed unused KEYWORDS.
;                 Changed plot titles.
;               Version 0.4, 2/3/01
;                 Changed to rcs_Survey_exttime.
;               Version 0.5, 14/3/01
;                 Removed CCLRC logo.
;                 Developed SPCT survey plot.
;               Version 0.6, 15/05/01
;                 Added CLEANBM2.
;                 Added IES BM survey plot.
;               Version 0.7, 25/05/01
;                 Added filename to plot abandoned.
;               Version 0.8, 26/06/01
;                 Changed standard IES survey plot to include all 10 detectors.
;                 Added IES CLEAN survey plot.
;               Version 0.7, 07/07/01
;                 Changed rcs_survey_extract to function.
;               Version 0.8, 20/07/01
;                 Added version no to footnote.
;                 changed printout if no data.
;               Version 0.9, 08/02/02
;                 Added EPAD2.
;               Version 1.0, 10/07/02
;                 Removed COLTAB.
;               Version 1.1, 03/03/03
;                 Moved LINEAR, BINS and ELOG keywords from rcs_survey_set to rcs_survey_calibrate.
;               Version 1.2, 28/03/03
;                 Changed definition of logo positions.
;               Version 1.3, 24/09/03
;                 Changed initialization of draw widget COMMON block..
;
; Version     :	Version 1.3, 24/09/03
;-
;**********************************************************

PRO rcs_survey, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, TYPE=type, $
  T0=input_start_time, T1=input_end_time

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  ; check type set up

  IF N_ELEMENTS(type) EQ 0 THEN type = 0

  IF KEYWORD_SET(postscript) THEN BEGIN
    new_postscript = postscript
  ENDIF ELSE IF KEYWORD_SET(bwps) THEN BEGIN
    new_bwps = bwps
  ENDIF ELSE IF KEYWORD_SET(png) THEN BEGIN
    new_png = png
  ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN
    new_gif = gif
  ENDIF

  ; set default plot type

  IF NOT KEYWORD_SET(windows) AND NOT KEYWORD_SET(postscript) AND $
     NOT KEYWORD_SET(png) AND NOT KEYWORD_SET(gif) AND NOT KEYWORD_SET(bwps) THEN windows=1

  ; get S/C

  sc = rcs_extract_sc()

  ; save current device

  devname = !D.NAME

  CASE type OF

    0 : BEGIN

          ; do standard IES plots

          IF NOT KEYWORD_SET(e3ddnm_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, e3ddnm_header, e3ddnm_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          detectors = INDGEN(9)

          detector_flags = INTARR(9)

          detector_flags[detectors] = 1

          npanels = N_ELEMENTS(detectors) + 1

          ; extract for detectors

          IF rcs_survey_extract( [start_time, end_time], detector_flags) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1,1e6], AXES=2

            ; loop through detectors

            FOR k = 0, N_ELEMENTS(detectors)-1 DO BEGIN

              ; plot data

              output_info.full_detector = k

              IF k EQ 0 THEN BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                    GIF=new_gif, BWPS=new_bwps, PG_POS=k, /NO_XAXIS, /NO_END, NPANELS=npanels, $
                                    HEADING = 'RAPID/SC'+sc+' IES SURVEY PLOT for ', $
                                    FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                   GOTO,  IOERROR

              ENDIF ELSE IF k EQ N_ELEMENTS(detectors)-1 THEN BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                  GIF=new_gif, BWPS=new_bwps, PG_POS=k, NPANELS=npanels) THEN $
                   GOTO,  IOERROR

              ENDIF ELSE BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                    GIF=new_gif, BWPS=new_bwps, PG_POS=k, /NO_XAXIS, /NO_END, NPANELS=npanels) THEN $
                   GOTO,  IOERROR

              ENDELSE

            ENDFOR

          ENDIF

      END

    1 : BEGIN

          ; do standard IIMS plots

          ; do detector 6 - H

          IF NOT KEYWORD_SET(i3dd_header_H) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_H, i3dd_data_H, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1 - H

          IF rcs_survey_extract([start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='H:6'

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=0, /NO_XAXIS, /NO_END, /FIXPANSIZ, $
                                HEADING = 'RAPID/SC'+sc+' IIMS SURVEY PLOT for ', $
                                FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                 GOTO,  IOERROR

          ENDIF

           ; do detector 6 - He

          IF NOT KEYWORD_SET(i3dd_header_He) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_He, i3dd_data_He, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1 - He

          IF rcs_survey_extract([start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='He:6'

            output_info.full_detector = 0

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=1, /NO_XAXIS, /NO_END, /FIXPANSIZ) THEN $
               GOTO,  IOERROR

          ENDIF

          ; do detector 6 - CNO

          IF NOT KEYWORD_SET(i3dd_header_CNO) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_CNO, i3dd_data_CNO, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1 - CNO

          IF rcs_survey_extract( [start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='CNO:6'

            output_info.full_detector = 0

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=2, /NO_XAXIS, /NO_END, /FIXPANSIZ) THEN $
                 GOTO,  IOERROR

          ENDIF

          IF NOT KEYWORD_SET(i3dd_header_H) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_H, i3dd_data_H, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 6 - H

          IF rcs_survey_extract( [start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0], FORMAT='SECTOR vs DETECTOR') THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0,FORMAT='SECTOR vs DETECTOR') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='H:6'

            ; do detector 6 - H

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=3, /NO_XAXIS, /NO_END, /FIXPANSIZ) THEN $
                 GOTO,  IOERROR

          ENDIF

          IF NOT KEYWORD_SET(i3dd_header_He) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_He, i3dd_data_He, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 6 - He

          IF rcs_survey_extract( [start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0], FORMAT='SECTOR vs DETECTOR') THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0,FORMAT='SECTOR vs DETECTOR') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='He:6'

            ; do detector 6 - He

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=4, /NO_XAXIS, /NO_END, /FIXPANSIZ) THEN $
                 GOTO,  IOERROR

          ENDIF

          IF NOT KEYWORD_SET(i3dd_header_CNO) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, i3dd_header_CNO, i3dd_data_CNO, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1 - He

          IF rcs_survey_extract( [start_time, end_time], [0,0,0,0,0,1,0,0,0,0,0,0],FORMAT='SECTOR vs DETECTOR') THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0,FORMAT='SECTOR vs DETECTOR') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-1,1e3], PTITLE='CNO:6'

             ; do detector 6 - CNO

            output_info.full_detector = 0

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=5, /FIXPANSIZ) THEN $
                 GOTO,  IOERROR

          ENDIF

      END


    2 : BEGIN

          ; do SGL plots

          ; do SGL01

          IF NOT KEYWORD_SET(sgl01_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, sgl01_header, sgl01_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for all detectors

          IF rcs_survey_extract([start_time, end_time], [0,0,0,1,1,1,1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0, FORMAT='DETECTOR vs SECTOR', PROCNAME='LINEPLOT') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[0.9, 1e6], /POINTS, PTITLE='SGL01'

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=0, /NO_XAXIS, /NO_END, $
                                HEADING = 'RAPID/SC'+sc+' SGLs SURVEY PLOT for ', $
                                FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                 GOTO,  IOERROR

          ENDIF

          ; do SGL01

          ; extract for all detectors

          IF rcs_survey_extract( [start_time, end_time], [1,1,1,0,0,0,0]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0, FORMAT='DETECTOR vs SECTOR', PROCNAME='LINEPLOT') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[0.9, 1e6], /POINTS, PTITLE='SGL01'

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=1, /NO_XAXIS, /NO_END) THEN $
                 GOTO,  IOERROR

          ENDIF

          IF NOT KEYWORD_SET(hk1_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, hk1_header, hk1_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for all detectors

          IF rcs_survey_extract([start_time, end_time], [1,1,1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0, /LINEAR, FORMAT='DETECTOR vs SECTOR', PROCNAME='LINEPLOT') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[0,4], /POINTS, PTITLE='HV'

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=2) THEN $
                 GOTO,  IOERROR

          ENDIF

      END

    3 : BEGIN

          ; do detector ESPCT

          IF NOT KEYWORD_SET(espct_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, espct_header, espct_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1

          IF rcs_survey_extract( [start_time, end_time], [1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-2,1e4], PTITLE='ESPCT'

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=0, /NO_XAXIS, /NO_END, $
                                HEADING = 'RAPID/SC'+sc+' SPCT SURVEY PLOT for ', $
                                FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                 GOTO,  IOERROR

          ENDIF

          ; do detector HSPCT

          IF NOT KEYWORD_SET(hspct_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, hspct_header, hspct_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1

          IF rcs_survey_extract( [start_time, end_time], [1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-2,1e4], PTITLE='HSPCT'

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=1, /NO_XAXIS, /NO_END) THEN $
                 GOTO,  IOERROR

          ENDIF

          ; do detector ISPCT-He

          IF NOT KEYWORD_SET(ispct_header_He) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, ispct_header_He, ispct_data_He, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1

          IF rcs_survey_extract( [start_time, end_time], [1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-2,1e4], PTITLE='ISPCT-He'

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=2, /NO_XAXIS, /NO_END) THEN $
                 GOTO,  IOERROR

          ENDIF

          ; do detector ISPCT-CNO

          IF NOT KEYWORD_SET(ispct_header_CNO) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, ispct_header_CNO, ispct_data_CNO, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for detectors 1

          IF rcs_survey_extract( [start_time, end_time], [1]) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e-2,1e4], PTITLE='ISPCT-CNO'

            ; plot data

            IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                GIF=new_gif, BWPS=new_bwps, PG_POS=3) THEN $
                 GOTO,  IOERROR

          ENDIF

      END

    4 : BEGIN

          ; do IES BM sector plots

          IF NOT KEYWORD_SET(cleanbm2_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, cleanbm2_header, cleanbm2_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          ; extract for all detectors

          IF rcs_survey_extract([start_time, end_time], [1,1,1,1,1,1,1,1,1], FORMAT='SECTOR vs DETECTOR') THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='SECTOR vs DETECTOR') THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e3,1e6], AXES=1, /NOBAD

            ; loop over detectors

            FOR k = 0, 8 DO BEGIN

              IF k EQ 8 THEN last = 1 ELSE last = 0

              output_info.full_detector = k

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                  GIF=new_gif, BWPS=new_bwps, PG_POS=k, NO_XAXIS=1-last, NO_END=1-last, /FIXPANSIZ, NPANELS=9, $
                                  HEADING = 'RAPID/SC'+sc+' IESBM SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                 GOTO,  IOERROR

            ENDFOR

          ENDIF

      END

    5 : BEGIN

          ; do CLEAN IES plots

          IF NOT KEYWORD_SET(clean_header) THEN GOTO, nodata

          ; transfer data to draw widget COMMON block

          rcs_draw_widget_block, clean_header, clean_data, /SET

          ; set up extraction start time and end time

          rcs_survey_exttime, full_header, start_time, end_time, T0=input_start_time, T1=input_end_time

          detectors = INDGEN(9)

          detector_flags = INTARR(9)

          detector_flags[detectors] = 1

          npanels = N_ELEMENTS(detectors) + 1

          ; extract for detectors

          IF rcs_survey_extract( [start_time, end_time], detector_flags) THEN BEGIN

            ; process data

            IF rcs_survey_calibrate(0, /CAL, /DIV, /RAT, /BINS, /ELOG) THEN GOTO, unfinished

            ; set options

            rcs_survey_set, RANGE=[1e0,1e6], ERANGE=[26,520], AXES=2, /NOBAD

            ; loop through detectors

            FOR k = 0, N_ELEMENTS(detectors)-1 DO BEGIN

              ; plot data

              output_info.full_detector = k

              IF k EQ 0 THEN BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                    GIF=new_gif, BWPS=new_bwps, PG_POS=k, /NO_XAXIS, /NO_END, NPANELS=npanels, $
                                    HEADING = 'RAPID/SC'+sc+' IES CLEAN SURVEY PLOT for ', $
                                    FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9)) THEN $
                   GOTO,  IOERROR

              ENDIF ELSE IF k EQ N_ELEMENTS(detectors)-1 THEN BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                    GIF=new_gif, BWPS=new_bwps, PG_POS=k, NPANELS=npanels) THEN $
                   GOTO,  IOERROR

              ENDIF ELSE BEGIN

                IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=new_postscript, PNG=new_png, $
                                    GIF=new_gif, BWPS=new_bwps, PG_POS=k, /NO_XAXIS, /NO_END, NPANELS=npanels) THEN $
                   GOTO,  IOERROR

              ENDELSE

            ENDFOR

          ENDIF

      END

    ELSE : rcs_message, 'TYPE NOT KNOWN'

  ENDCASE

  ; set up processing info

  output_info.minimum = -1
  output_info.maximum = -1

  RETURN

IOERROR:

  res = rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
           GIF=gif, BWPS=bwps, /IOERROR)

UNFINISHED: res = rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
           GIF=gif, BWPS=bwps, /UNFINISHED)

  RETURN

NODATA : res = rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
           GIF=gif, BWPS=bwps, /NODATA)

END
