;+
; Project     :	POLAR - CEPPAD
;
; Name        :	rcs_survey_calibrate
;
; Purpose     :	Processes required data.
;
; Explanation : Process data.
;
; Use         : < error = rcs_survey_calibrate(full_detector, RANGE=range, DETECTOR_AVERAGE=detector_average, FORMAT=format) >
;
; Inputs      : full_detector : INT detector for display.
;
; Opt. Inputs : None.
;
; Outputs     : Updates structures in COMMON block.
;               error : INT flag indicating error.
;
; Opt. Outputs:	None.
;
; Keywords    : RANGE     : FLTARR[2] overrides data min and max.
;               FORMAT    : STRINGoverrides default format.
;               PROCNAME  : STRING overrides default procname.
;               CAL       : FLAG sets calibration on
;               RAT       : FLAG sets rates on
;               DIV       : FLAG sets energy division on
;               LINEAR    : FLAG indicating linear rather than log counts plotted.
;               BINS      : FLAG indicating true energies shown (rather than channels)
;               ELOG      : FLAG indicating logarithmic energy axis
;
; Written     :	Version 0.0, Martin Carter, RAL, 28/11/97
;
; Modified    :    Version 0.1, MKC, 18/2/98
;                    Added HISTe, HISTp processing.
;                    Added RANGE keyword.
;                  Version 0.2, 7/10/98
;                    Added Magnetic field and attitude arrays to common block and to ies extdata
;                    Allowed detector sum.
;                  Version 0.3, 30/10/98
;                    Separated from cep_extract.
;                  Version 0.4, 12/01/99
;                    Changed back to including bad data.
;                  Version 0.5, 22/2/99
;                    Added output_info tags.
;                  Version 0.6, 28/2/01
;                    Adapted for RAPID.
;                  Version 0.7, 09/05/02
;                    Added full_band to output_info structure.
;                  Version 0.8, 03/03/03
;                    Added LINEAR, BINS and ELOG keywords.
;                    These are needed by ies_get_hilo and ies_get_minmax.
;
; Version     :	Version 0.8, 03/03/03
;-
;**********************************************************

FUNCTION rcs_survey_calibrate, full_detector, DETECTOR_AVERAGE=detector_average, FORMAT=format, $
  PROCNAME=procname, CAL=cal, DIV=div, RAT=rat, LINEAR=linear, BINS=bins, ELOG=elog

  ; define common blocks used internally for draw widgets
  ; full_header   = structure containing original data header information
  ; full_data     = structure array containing original data
  ; header        = structure containing extracted data header information  ** used
  ; data          = structure array containing extracted data               ** used
  ; output_info   = structure containing plotting and processing info       ** used
  ; output_chans  = array containing processed channel positions
  ; output_array  = array containing processed data for plotting
  ; ids           = structure giving widget IDs
  ; dnfull        = co-ordinate conversion array for full window
  ; dnscroll      = co-ordinate conversion array for magnified windows
  ; files         = STRARR giving data file names
  ; ephem         = structure containing ephemeris data
  ; mf            = structure containing magnetic field data
  ; at            = structure containing attitude data

  COMMON ies_draw_widget_block, input_header, input_data, header, data, $
           output_info, output_chans, output_array, ids, dnfull, dnscroll, files, ephem, mf, at

  ; set up defaults

  IF NOT KEYWORD_SET(format) THEN format = 'ENERGY vs DETECTOR'

  IF NOT KEYWORD_SET(procname) THEN procname = 'SPECTRAL'

  ; full_sector = 0 => sector average

  output_info = {log:1, cal:0, div:0, rat:0, shift:0, subtract:0, track:1, $
         rng:0.0, button_labels:STRARR(12), button_values:[0,0,0,0,0,0,0,0,0,0,0,0], procname:procname, $
         full_only:0, full_detector:full_detector, full_sector:0, full_band:0, axes:1, band_labels:STRARR(20), noutputs:0, $
         format:format, ptitle:STRARR(20), time:0.0D0, ysamples:0, $
         minimum:1.e0, maximum:1.e6, elow:0.0, ehigh:0.0, min:1, max:1, elo:0, ehi:0 }

  IF KEYWORD_SET(cal) THEN output_info.cal = 1

  IF KEYWORD_SET(div) THEN output_info.div = 1

  IF KEYWORD_SET(rat) THEN output_info.rat = 1

  IF KEYWORD_SET(linear) THEN output_info.log = 0

  IF KEYWORD_SET(bins) THEN output_info.button_values[0] = 1

  IF KEYWORD_SET(elog) THEN output_info.button_values[3] = 1

  IF ies_calibrate(/QUIET) THEN RETURN, 1 ELSE RETURN, 0

END
