;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	RCS_SURVEY_EXTTIME
;
; Purpose     :	Sets up start and end times from requested time range for IES data array.
;
; Explanation : Sets up start and end times from requested time range for IES data array.
;
; Use         : < rcs_survey_exttime, header, start_time, end_time, T0=input_start_time, T1=input_end_time >
;
; Inputs      : header : structure containing data set info.
;               start_time : DOUBLE TAI time of start of data extraction
;               end_time   : DOUBLE TAI time of end of data extraction
;
; Opt. Inputs : None.
;
; Outputs     : Changes common block values.
;
; Opt. Outputs:	None.
;
; Keywords    : T0          = DOUBLE TAI time default start
;               T1          = DOUBLE TAI time default start
;
; Written     :	Version 0.0, 2/3/01
;
; Modified    : None.
;
; Version     :	Version 0.0, 2/3/01
;-
;**********************************************************

PRO rcs_survey_exttime, header, start_time, end_time, T0=input_start_time, T1=input_end_time

  ; deal with start times

  IF KEYWORD_SET ( input_start_time ) THEN start_time = anytim2tai(input_start_time) ELSE start_time = header.tstart

  ; deal with end times

  IF KEYWORD_SET ( input_end_time ) THEN end_time = anytim2tai(input_end_time) ELSE end_time = header.tstop

END