;+
; Project     :	POLAR - CEPPAD
;
; Name        :	rcs_survey_set
;
; Purpose     :	Sets various display options.
;
; Explanation : Sets various display options
;
; Use         : < rcs_survey_set, full_detector, RANGE=range, DETECTOR_AVERAGE=detector_average, FORMAT=format) >
;
; Inputs      : full_detector : INT detector for display.
;
; Opt. Inputs : None.
;
; Outputs     : Updates structures in COMMON block.
;               error : INT flag indicating error.
;
; Opt. Outputs:	None.
;
; Keywords    : RANGE     : FLTARR[2] overrides data min and max.
;               ERANGE    : FLTARR[2] energy range.
;               AXES      : INT indicating if LUT panel required
;               POINTS    : FLAG indcating if lineplot requires points plotted
;               LINES     : FLAG indicating if lineplot requires lines plotting
;               PTITLE    : STRARR detector titles
;               NOBAD     : FLAG indicating bad data not plotted
;
; Written     :	Version 0.0, Martin Carter, RAL, 28/11/97
;
; Modified    :    Version 0.1, MKC, 18/2/98
;                    Added HISTe, HISTp processing.
;                    Added RANGE keyword.
;                  Version 0.2, 7/10/98
;                    Added Magnetic field and attitude arrays to common block and to ies extdata
;                    Allowed detector sum.
;                  Version 0.3, 30/10/98
;                    Separated from cep_extract.
;                  Version 0.4, 12/01/99
;                    Changed back to including bad data.
;                  Version 0.5, 22/2/99
;                    Added output_info tags.
;                  Version 0.6, 28/2/01
;                    Adapted for RAPID.
;                  Version 0.7, 14/05/02
;                    Added KEYWORD LINES.
;                  Version 0.8, 03/03/03
;                    Removed LINEAR, BINS and ELOG keywords.
;                    These are needed by ies_get_hilo and ies_get_minmax.
;
; Version     :	Version 0.8, 03/03/03
;-
;**********************************************************

PRO rcs_survey_set, RANGE=range, ERANGE=erange, AXES=axes, POINTS=points, LINES=lines, $
                    PTITLE=ptitle, NOBAD=nobad

  ; define common blocks used internally for draw widgets
  ; full_header   = structure containing original data header information
  ; full_data     = structure array containing original data
  ; header        = structure containing extracted data header information  ** used
  ; data          = structure array containing extracted data               ** used
  ; output_info   = structure containing plotting and processing info       ** used
  ; output_chans  = array containing processed channel positions
  ; output_array  = array containing processed data for plotting
  ; ids           = structure giving widget IDs
  ; dnfull        = co-ordinate conversion array for full window
  ; dnscroll      = co-ordinate conversion array for magnified windows
  ; files         = STRARR giving data file names
  ; ephem         = structure containing ephemeris data
  ; mf            = structure containing magnetic field data
  ; at            = structure containing attitude data

  COMMON ies_draw_widget_block, input_header, input_data, header, data, $
           output_info, output_chans, output_array, ids, dnfull, dnscroll, files, ephem, mf, at

  ; ies_calibrate sets .ptitle :
  ;    'ENERGY vs DETECTOR' : 'Dt' + header.ptitle
  ;    'ENERGY vs SECTOR'   : 'Sc' + rcs_strtrim(sector_list)
  ;    'SECTOR vs DETECTOR' : 'Dt' + header.ptitle
  ;    'DETECTOR vs SECTOR' : 'Sc' + rcs_strtrim(sector_list)
  ;    'PITCH ANGLE vs ENERGY' : 'Energy band '+rcs_strtrim(INDGEN(header.nbands))
  ;
  ; ies_window_plot, if pg_pos set, uses (via ies_do_plot, /FULL)
  ;   output_info.ptitle(element) to label color bar
  ;   where
  ;    'ENERGY vs DETECTOR' : element = output_info.full_detector
  ;    'ENERGY vs SECTOR'   : element  = output_info.full_sector
  ;    'SECTOR vs DETECTOR' : element  = output_info.full_detector
  ;    'DETECTOR vs SECTOR' : element  = 0
  ;    'PITCH ANGLE vs ENERGY' : element  = header.nbands-1

  ; IF output_info.procname EQ 'SPECTRAL' THEN BEGIN
  ;   output_info.button_labels = ['BINS','','NO BAD','ELOG','','','','','','','','']
  ; ENDIF ELSE IF output_info.procname EQ 'LINEPLOT' THEN BEGIN
  ;   output_info.button_labels = ['BINS', 'POINTS','NO BAD','','LINES','','','','','','','']
  ; ENDIF ELSE IF output_info.procname EQ 'PROFILES' THEN BEGIN
  ;   output_info.button_labels = ['BINS','','NO BAD','ELOG','','','','','','','','']
  ; ENDIF ELSE IF output_info.procname EQ 'ANGLE/ANGLE' THEN BEGIN
  ;   output_info.button_labels = ['BINS','','','','','MASK','PROJ','','','','','']
  ; ENDIF ELSE IF output_info.procname EQ 'TIMELINE' THEN BEGIN
  ;   output_info.button_labels = ['BINS','','','','','MASK','PROJ','/2','/4','/8','/16','']

  IF KEYWORD_SET(axes) THEN output_info.axes = axes

  IF KEYWORD_SET(points) THEN output_info.button_values[1] = points

  IF KEYWORD_SET(lines) THEN output_info.button_values[4] = 1

  IF KEYWORD_SET(ptitle) THEN output_info.ptitle = ptitle

  IF KEYWORD_SET(nobad) THEN output_info.button_values[2] = 1

  IF KEYWORD_SET(range) THEN BEGIN

    output_info.minimum = range[0]

    output_info.maximum = range[1]

  ENDIF

  IF KEYWORD_SET(erange) THEN BEGIN

    output_info.elo = 1

    output_info.ehi = 1

    output_info.elow = erange[0]

    output_info.ehigh = erange[1]

  ENDIF

END
