;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TEMPERATURE_PLOT
;
; Purpose     :	Produces temperature plot.
;
; Explanation : Produces temperature plot.
;
; Use         : < >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 04/07/01
;
; Modified    :	Version 0.1, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 0.2, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 08/10/03
;-
;**********************************************************

PRO rcs_temperature_plot, sc, WIN=win, PS=ps, PNG=png, GIF=gif, MODE=modelist, MINIMUM=minimum, MAXIMUM=maximum, TYPE=type

  IF NOT (KEYWORD_SET(win) OR KEYWORD_SET(ps) OR KEYWORD_SET(png) OR KEYWORD_SET(gif)) THEN win=1

  IF NOT KEYWORD_SET(psym) THEN psym = 3

  ; removed  LOADCT, 39 since this is not compatible with batch operation

  sc = rcs_strtrim(sc)

  IF NOT KEYWORD_SET(minimum) THEN minimum = 0

  IF NOT KEYWORD_SET(maximum) THEN maximum = 40

  ; check if margins defined

  xmargin = [8,3]

  ymargin = [1.5,0.6]

  subtitles = ['ERISTREF','ERIHKTRF']

  temps = 0

  RESTORE, concat_dir(concat_dir(ies_get_dir('IF',/RAPID),'RAPID_'+sc),'temps.dat')

  HELP, temps

  tstart = temps[0].time

  tstop = temps[N_ELEMENTS(temps)-1].time

  IF NOT KEYWORD_SET(type) THEN type = 0

  CASE type OF

    0: BEGIN

         ; set up output file name

         dir = concat_dir(ies_get_dir('PNG',/RAPID),rcs_get_scname(sc))

         IF KEYWORD_SET(png) THEN BEGIN

           png = concat_dir ( dir, 'sc' + sc + '_temperatures.png')

         ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

           gif = concat_dir ( dir, 'sc' + sc + sc + '_temperatures.gif')

         ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

           ps = concat_dir ( dir, 'sc' + sc + sc + '_temperatures.ps')

         ENDIF

         info = rcs_start_plot( WIN=win, PS=ps, PNG=png, GIF=gif, HEADING='SC'+sc+' RAPID TEMPERATURES')

         FOR k = 0, 1 DO rcs_plot_panel, temps.time, temps.data[k], info, 2, k, tstart, tstop, minimum, maximum, xmargin, ymargin, $
                 subtitles[k]

         rcs_end_plot, info, /UPDATED

      END

    ELSE : PRINT, 'INVALID TYPE'

  ENDCASE

END