;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_SCI
;
; Purpose     :	Batch process SCI files.
;
; Explanation : Batch process SCI files.
;               If days not defined then asks user to specify days and sc
;
; Use         : < rcs_batch_sci >
;
; Inputs      : None.
;
; Opt. Inputs : sc   : STRING giving S/C i.e '1','2','3','4'
;               days : STRARR containing days for processing in form yymmdd.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : Version 0.1, 17/07/03
;                 Added error message if SCI file source version not obtainable.
;               Version 0.2, 03/09/03
;                 Changed format of version specification.
;                 Changed rcs_if_exists.
;
; Version     :	Version 0.2, 03/09/03
;-
;**********************************************************

PRO rcs_batch_sci, sc, days

  ; NB days can be '' in which case KEYWORD_SET(days) returns 0
  ; If days not defined then asks user to specify days and sc

  IF N_ELEMENTS(days) EQ 0 THEN rcs_get_days, sc, days, /SCI

  IF days[0] EQ '' THEN RETURN

  ; loop through files

  ids = rcs_get_ids()

  ; if interactive then set hourglass

  IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

    rcs_text, 'PROCESSING '+days[k], /OVERRIDE

    ; reset IF data

    rcs_reset_if

    ; get source version

    vs = rcs_read_sci_version(sc,days[k])

    ; check if source version found OK

    IF KEYWORD_SET(vs) THEN BEGIN

      ; check if want to process SCI file

      IF rcs_get_force() OR NOT rcs_if_exists(sc, days[k], CD_VERSION=vs) THEN BEGIN

        ; process SCI file to IF data set

        rcs_batch_sci_process, sc, days[k]

      ENDIF ELSE BEGIN

        rcs_text, 'IF FILES ALREADY EXIST FOR SC '+sc+', DAY '+days[k], /OVERRIDE

      ENDELSE

    ENDIF ELSE rcs_message, 'UNABLE TO GET SCI FILE VERSION FOR DAY : '+STRING(days[k]), /INFORMATIONAL

  ENDFOR

END
