;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_SCI_PROCESS
;
; Purpose     :	Batch process SCI file.
;
; Explanation : Batch process SCI file.
;
; Use         : < rcs_batch_sci_process, sc, day >
;
; Inputs      : sc   : STRING character giving SC for processing.
;               day  : day  : STRING containing day in form yymmdd for processing.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : Version 0.1, 31/12/02
;                 Removed processing of MTRX data for now since not yet produced in SCI files.
;               Version 0.2, 16/09/03
;                 Modified to pass mdata header, data and samples through argument lists instead of
;                 just mdata.
;
; Version     :	Version 0.2, 16/09/03
;-
;**********************************************************

PRO rcs_batch_sci_process, sc, day

  ; get IF data required

  use = rcs_get_use()

  ; get MDATA data

  rcs_sci_process_mdata, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples

  ; get IES data

  rcs_sci_process_e3dd, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples

  ; get EPAD data

  rcs_sci_process_epad, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples

  ; get IIMS data

  rcs_sci_process_i3dd, sc, day, use

  ; get IPAD data

  rcs_sci_process_ipad, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples

  ; get HSPCT data

  rcs_sci_process_hspct, sc, day, use

  ; get ISPCT data

  rcs_sci_process_ispct, sc, day, use

  ; get MTRX data

  ; rcs_sci_process_mtrx, sc, day, use

  ; get SGL01 data

  rcs_sci_process_sgl01, sc, day, use

  ; get SGL2 data

  rcs_sci_process_sgl2, sc, day, use

  ; get SGL3 data

  rcs_sci_process_sgl3, sc, day, use

  ; save IF files

  rcs_save_if, DAY=day

END
