;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_EDB_NO
;
; Purpose     :	Parses K line in SCI file to give EDB no.
;
; Explanation : Parses K line in SCI file to give EDB no.
;
; Use         : < edb_no = rcs_get_edb_no(vals) >
;
; Inputs      : vals   : STRARR[] current line tokenized
;
; Opt. Inputs : None.
;
; Outputs     : edb_no : INT current edb no
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 25/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 25/07/02
;-
;**********************************************************

FUNCTION rcs_get_edb_no, vals

  list = WHERE(vals EQ 'EDB',count)

  IF count NE 1 THEN rcs_message, /IMPLEMENTATION

  IF list[0]+1 GE N_ELEMENTS(vals) THEN rcs_message, /IMPLEMENTATION

  edb_no = FIX(vals[list[0]+1])

  IF edb_no LT 0 OR edb_no GT 255 THEN rcs_message, /IMPLEMENTATION

  RETURN, edb_no

END
