;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SCIFILES
;
; Purpose     :	Gets filenames of all SCI files for a particular spacecraft.
;
; Explanation : Gets filenames of all SCI files for a particular spacecraft.
;               Includes path.
;               Explicitly looks for SCI files with suffix 'K' for raw counts in filename.
;               Allows any file extension in order to allow compressed file where the 'SCI' file extension has been replaced
;               by compressed file extension.
;               Allows particular day to be specified.
;
; Use         : < files = rcs_get_scifiles(sc) >
;
; Inputs      : sc : STRING character giving S/C
;
; Opt. Inputs : None.
;
; Outputs     : files : STRARR all SCI files.
;
; Opt. Outputs: None.
;
; Keywords    : COUNT  : INT returns no. of if files
;               DAY    : STRING day filter in form yyyymmdd
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : Version 0.1, 17/01/03
;                 Specified that only want files of type _K.SCI rather than '*'
;               Version 0.2, 11/03/03
;                 Added postfix argument to allow gzipped files.
;
; Version     :	Version 0.2, 11/03/03
;-
;**********************************************************

FUNCTION rcs_get_scifiles, sc, COUNT=count, DAY=day

  ; initialize

  files = ''
  count = 0

  ; set up filter
  ; NB source can be ''

  IF NOT KEYWORD_SET(day) THEN day = '*'

  ; check directory exists

  IF NOT rcs_dir_exist(rcs_sciname(sc, /PATH)) THEN BEGIN

    rcs_message, 'SCI DIRECTORY :'+rcs_sciname(sc, /PATH)+', DOES NOT EXIST', /INFORMATIONAL

    RETURN, files

  ENDIF

  ; get filenames

  files = FINDFILE(rcs_sciname(sc, day, '*', 'K', '*'),COUNT=count)

  RETURN, files

END
