;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_READ_SCI
;
; Purpose     :	Reads SCI file.
;
; Explanation : Reads SCI file.
;               Data from SCI file is held in COMMON block.
;               sci_head structure contains general header information
;               sci_data structure contains info on each sample and link to data
;               sci_samples array contains data
;               sci_state contains current state info
;               NB Have set up a large sized sci_data and sci_samples arrays but may still grow
;               if needed.
;
; Use         : < st = rcs_read_sci(filename) >
;
; Inputs      : filename : STRING file name with possible wild characters.
;
; Opt. Inputs : None.
;
; Outputs     : head : STRUCTURE header information
;               data : STRUCTURE[] info for each sample
;               samples : FLOAT[] data samples
;
; Opt. Outputs: None.
;
; Keywords    : EXPECTED : INTARR(4) no of samples expected in each telemetry mode
;
; Written     :	Version 0.0, 05/07/02
;
; Modified    : Version 0.1, 11/07/02
;                 Modified to allow gzipped SCI files.
;                 Moved ON_IOERROR to rcs_parse_sci.
;                 Moved CLOSE file to rcs_parse_sci.
;               Version 0.2, 02/09/03
;                 Renamed sci_head.version sci_head.cd_version.
;               Version 0.3, 18/09/03
;                 Allowed lowercase 'sci' extension for SCI files.
;                 Removed flag from sci_state.
;               Version 0.4, 17/10/03
;                 Emptied COMMON block after use to free up space.
;                 Removed code that did not set up sci_data and sci_samples if already set up.
;                 Increase default size of sci samples.
;
; Version     :	Version 0.4, 17/10/03
;-
;**********************************************************

FUNCTION rcs_read_sci, filename, head, data, samples, EXPECTED=expected

  COMMON rcs_sci_block, sci_head, sci_data, sci_state, sci_samples

  ; initialize common block

  sci_head = {data_class:'', contents:'', cd_version:'', fill_value:!VALUES.F_NAN, npoints:0L}

  sci_state = {type:-1, lut:-1, pos:0L, throwaway:0L}

  ; max no. of samples is 86400/4 = 21600

  sci_data = REPLICATE( {type:-1, lut:-1, flag:0L, edb_no:0, pos:0L, nvals:0L, time:0.0d0}, 22000L)

  ; max no of data words is 21600*12*16*9=21600*1728

  sci_samples = FLTARR(1024L*1024L)

  ; open file

  IF NOT rcs_open_file(filename, unit, EXTENSION=['SCI','sci']) THEN RETURN, 0

  ; read file

  IF NOT rcs_parse_sci(unit, EXPECTED=expected) THEN RETURN, 0

  ; return data

  IF sci_head.npoints EQ 0 THEN RETURN, 0

  head = sci_head

  data = TEMPORARY(sci_data[0:sci_head.npoints-1])

  samples = TEMPORARY(sci_samples[0:sci_state.pos-1])

  RETURN, 1

END
