;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_READ_SCI_VERSION
;
; Purpose     :	Reads SCI source version letter.
;
; Explanation : Reads SCI source version letter.
;
; Use         : < vs = rcs_read_sci_version(sc, day) >
;
; Inputs      : sc   : STRING character giving SC for processing.
;               day  : STRING containing day in form yymmdd for processing.
;
; Opt. Inputs : None.
;
; Outputs     : vs : SRING character giving SCI source version
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 08/08/02
;
; Modified    : Version 0.1, 11/07/02
;                 Modified to allow gzipped SCI files.
;
; Version     :	Version 0.1, 11/07/02
;-
;**********************************************************

FUNCTION rcs_read_sci_version, sc, day


  ON_IOERROR, ioerror

  rcs_text, 'Extracting source version from E3DD SCI data file'

  ; open file

  IF NOT rcs_open_file(rcs_sciname(sc, day, 'E3DD','K','*'), unit, file) THEN RETURN, ''

  ; set up local string for each line

  line = ''

  ; read each line

  WHILE (NOT EOF(unit)) AND NOT KEYWORD_SET(vs) DO BEGIN

    READF, unit, line

    ; check if source is defined

    IF rcs_strstart(line,'! Source CD-ROM(s): ', POS=pos) THEN BEGIN

      source_files = rcs_strsplit(STRMID(line,pos,40), '', '', ',')

      vs = STRLOWCASE(STRMID(source_files[0],10,1))

      rcs_text, '> Source version is : '+vs

    ENDIF

  ENDWHILE

  ; close file

  FREE_LUN, unit

  ; return data

  IF KEYWORD_SET(vs) THEN RETURN, vs ELSE BEGIN

    rcs_message, 'CDROM VERSION no. not defined for file : '+file, /INFORMATIONAL

    RETURN, ''

  ENDELSE

ioerror :

  dummy = rcs_sci_ioerror(unit)

  RETURN, ''

END
