;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_CHECK
;
; Purpose     :	Checks SCI data obtained from separate SCI files are compatible.
;
; Explanation : Checks SCI data obtained from separate SCI files are compatible.
;
; Use         : < err = rcs_sci_check(head0, data0, samples0, $
;                                     head1, data1, samples1 >
;
; Inputs      : head0 : STRUCTURE header information
;               data0 : STRUCTURE[] info for each sample
;               samples0 : FLOAT[] data samples
;               head1 : STRUCTURE header information
;               data1 : STRUCTURE[] info for each sample
;               samples1 : FLOAT[] data samples
;
; Opt. Inputs : None.
;
; Outputs     : err : INT flag indicating error
;                          0 : no errors
;                          1 : correctable error
;                          2 : non correctable error
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : Version 0.1, 19/09/03
;                 Moved CORRECTion outside routine.
;
; Version     :	Version 0.1, 19/09/03
;-
;**********************************************************

FUNCTION rcs_sci_check, head0, data0, samples0, head1, data1, samples1

  ; do some checks

  IF head0.npoints NE head1.npoints THEN BEGIN

    rcs_text, head0.data_class+'-'+head1.data_class+' : mismatched number of points',/OVERRIDE

    rcs_text, head0.data_class+' : '+rcs_strtrim(head0.npoints),/OVERRIDE

    rcs_text, head1.data_class+' : '+rcs_strtrim(head1.npoints),/OVERRIDE

    RETURN, 1

  ENDIF

  IF TOTAL(data0.time-data1.time) NE 0.0d0 THEN BEGIN

    rcs_text, head0.data_class+'-'+head1.data_class+' : mismatched times',/OVERRIDE

    RETURN, 1

  ENDIF

  IF TOTAL(data0.edb_no-data1.edb_no) NE 0L THEN BEGIN

    rcs_text, head0.data_class+'-'+head1.data_class+' : mismatched edb numbers',/OVERRIDE

    RETURN, 2

  ENDIF

  ; check types
  ; allow types to be different because E3DD or SGL01 data may have types corrected

  IF TOTAL(data0.type-data1.type) NE 0L THEN BEGIN

    rcs_text, head0.data_class+'-'+head1.data_class+' : mismatched types encountered',/OVERRIDE

    data1.type = data0.type

  ENDIF

  IF head0.contents NE 'raw counts' OR head1.contents NE 'raw counts' THEN BEGIN

    rcs_text, head0.data_class+'-'+head1.data_class+' : mismatched contents',/OVERRIDE

    RETURN, 2

  ENDIF

  ; return no errors

  RETURN, 0

END
