;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_CHECK_FILL_VALUES
;
; Purpose     :	Checks if SCI data contains fill values.
;
; Explanation : Checks if SCI data contains fill values.
;
; Use         : < res = rcs_sci_check_fill_values(fill_value,data)>
;
; Inputs      : fill_value : FLOAT fill value
;               data : FLTARR[] data values
;
; Opt. Inputs : None.
;
; Outputs     : res : INT flag indicating error
;                          0 : no fill values
;                          1 : data contains fill value
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 19/09/03
;
; Modified    :
;
; Version     :	Version 0.0, 19/09/03
;-
;**********************************************************

FUNCTION rcs_sci_check_fill_values, fill_value, data

  ; check fill value set

  IF NOT FINITE(fill_value) THEN rcs_message, /IMPLEMENTATION

  RETURN, TOTAL(data EQ fill_value) NE 0

END
