;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_CORRECT_TYPE
;
; Purpose     :	Corrects telemetry type.
;
; Explanation : Corrects telemetry type.
;
; Use         : < rcs_sci_correct_type, state, nvals, line >
;
; Inputs      : state : STRUCTURE giving info current telemetry state
;               nvals : INT no of values in current smaple
;               line  : STRING current line
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : EXPECTED : INTARR(4) no of samples expected in each telemetry mode
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : Version 0.1, 06/12/02
;                 Modified logic so that does no printout for type=-1
;                 but still correct type.
;                 Prints warning if type -2 or wrong.
;
; Version     :	Version 0.0, 04/07/02
;-
;**********************************************************

PRO rcs_sci_correct_type, state, nvals, line, EXPECTED=expected

  ; check have expected no of samples
  ; correct state if necessary

  IF NOT KEYWORD_SET(expected) THEN RETURN

  ; initially state.type set to -1
  ; allow type not to be defined for initial sample but guess

  IF state.type GE 0 THEN IF nvals EQ expected[state.type] THEN RETURN

  IF state.type NE -1 THEN BEGIN

    rcs_text, '> unexpected no. of samples for telemetry type '+rcs_strtrim(state.type), /OVERRIDE

    rcs_text, '> '+line,/OVERRIDE

  ENDIF

  list = WHERE(expected EQ nvals, count)

  IF count GT 0 THEN state.type = list[0]

END
