;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_FIX
;
; Purpose     :	Ensure each data0 sample has a corresponding data1 sample
;
; Explanation : Ensure each data0 sample has a corresponding data1 sample.
;               Generate list of common samples.
;
; Use         : < rcs_sci_fix, head0, data0, samples0, head1, data1, samples1 >
;
; Inputs      : head0    : STRUCTURE header information
;               data0    : STRUCTURE[] info for each sample
;               samples0 : FLTARR[] data samples
;               head1    : STRUCTURE header information
;               data1    : STRUCTURE[] info for each sample
;               samples1 : FLTARR[] data samples
;
; Opt. Inputs : None.
;
; Outputs     : Modifies inputs.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
;
; Written     :	Version 0.0, 25/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 25/07/02
;-
;**********************************************************

PRO rcs_sci_fix, head0, data0, samples0, head1, data1, samples1

  ; have time differences between the data and/or different no. of points

  ; find initial corresponding data0 and data1 samples

  list = WHERE(data0.time NE data1.time, count)

  ; if no time differences

  IF count EQ 0 THEN BEGIN

    ; must be different no. of points in the data sets

    npoints = MIN([head0.npoints,head1.npoints])

    head0.npoints = npoints
    data0 = data0[0:npoints-1]
    samples0 = samples0[0:data0[npoints-1].pos+data0[npoints-1].nvals-1]

    head1.npoints = npoints
    data1 = data1[0:npoints-1]
    samples1 = samples1[0:data1[npoints-1].pos+data1[npoints-1].nvals-1]

    RETURN

  ENDIF

  ; start at first time difference

  start = list[0]

  ; find corresponding data0 and data1 samples

  ; initialize no .of common points after first time difference

  n = 0

  ; loop through times 0

  p = start

  FOR k = start, N_ELEMENTS(data0)-1L DO BEGIN

    WHILE data1[p].time LT data0[k].time AND p LT N_ELEMENTS(data1)-1 DO p = p + 1

    IF k NE p THEN rcs_text, 'Mismatched '+head0.contents+'-'+head1.contents+$
      ', index : '+rcs_strtrim(k)+', '+rcs_strtrim(p)+$
      ', edbs : '+rcs_strtrim(data0[k].edb_no)+', '+rcs_strtrim(data1[p].edb_no)

    IF data1[p].time EQ data0[k].time THEN BEGIN

      n = n + 1

      IF n EQ 1 THEN BEGIN

        new_head0 = head0

        new_head0.npoints = n

        new_data0 = data0[k]

        new_samples0 = samples0[data0[k].pos:data0[k].pos+data0[k].nvals-1]

        new_head1 = head1

        new_head1.npoints = n

        new_data1 = data1[p]

        new_samples1 = samples1[data1[p].pos:data1[p].pos+data1[p].nvals-1]

      ENDIF ELSE BEGIN

        new_head0.npoints = n

        new_data0 = [new_data0,data0[k]]

        new_samples0 = [new_samples0,samples0[data0[k].pos:data0[k].pos+data0[k].nvals-1]]

        new_head1.npoints = n

        new_data1 = [new_data1,data1[p]]

        new_samples1 = [new_samples1,samples1[data1[p].pos:data1[p].pos+data1[p].nvals-1]]

      ENDELSE

    ENDIF

  ENDFOR

  ; get initial common samples

  IF start EQ 0 THEN BEGIN

    head0 = 0
    data0 = 0
    samples0 = 0
    head1 = 0
    data1 = 0
    samples1 = 0

  ENDIF ELSE BEGIN

    head0.npoints = start
    data0 = data0[0:start-1]
    samples0 = samples0[0:data0[start-1].pos+data0[start-1].nvals-1]

    head1.npoints = start
    data1 = data1[0:start-1]
    samples1 = samples1[0:data1[start-1].pos+data1[start-1].nvals-1]

  ENDELSE

  ; add common samples after first time difference

  IF n GT 0 THEN BEGIN

    IF start EQ 0 THEN BEGIN

      head0 = new_head0
      data0 = new_data0
      samples0 = new_samples0

      head1 = new_head1
      data1 = new_data1
      samples1 = new_samples1

    ENDIF ELSE BEGIN

      head0.npoints = head0.npoints + new_head0.npoints
      data0 = [data0,new_data0]
      samples0 = [samples0,new_samples0]

      head1.npoints = head1.npoints + new_head1.npoints
      data1 = [data1,new_data1]
      samples1 = [samples1,new_samples1]

    ENDELSE

  ENDIF

END
