;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_PROCESS_HSPCT
;
; Purpose     : Reads and processes HSPCT SCI data.
;
; Explanation : Reads and processes HSPCT SCI data.
;
; Use         : < rcs_sci_process_hspct, sc, day, use >
;
; Inputs      : use : STRUCTURE giving info on what IF data sets to cretae
;               sc  : STRING character giving S/C
;               day  : STRARR containing IF day name for processing.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 23/07/02
;
; Modified    : Version 0.1, 04/12/02
;                 Added OVERRIDE to 1st printout.
;               Version 0.2, 11/07/02
;                 Modified to allow gzipped SCI files.
;               Version 0.3, 03/09/03
;                 Changed to new version control.
;               Version 0.4, 16/09/03
;                 Added check for fill values.
;               Version 0.5, 17/10/03
;                 Improved check for fill values.
;               Version 0.6, 08/01/04
;                 Renamed rcs sw version.
;
; Version     : Version 0.6, 08/01/04
;-
;**********************************************************

PRO rcs_sci_process_hspct, sc, day, use

  ; get HSPCT data

  IF KEYWORD_SET(use.hspct) THEN BEGIN

    ; get hspct raw count data

    name = rcs_sciname(sc,day,'HSPCT','K','*')

    rcs_text, 'Reading file : '+name, /OVERRIDE

    ; test all files exist

    IF ies_file_exists(name) THEN BEGIN

      IF rcs_read_sci(name, sci_head, sci_data, sci_samples ) THEN BEGIN

        rcs_text, 'Processing HSPCT SCI data'

        ; get vs

        IF NOT KEYWORD_SET(sci_head.cd_version) THEN rcs_message, /IMPLEMENTATION

        vs = rcs_if_version( SOURCE=rcs_get_source(), CD_VERSION=sci_head.cd_version, SW_VERSION=ies_sw_version())

        ; get flags indicating fill values

        list = WHERE(NOT sci_data.flag, count)

        ; set up no of points rejected due to fill values

        n_duff_points = sci_head.npoints - count

        ; loop through samples

        FOR k = 0, count-1 DO BEGIN

          ; index into arrays

          kk = list[k]

          data = sci_samples[sci_data[kk].pos:sci_data[kk].pos+sci_data[kk].nvals-1]

          ; get flag

          flag = 0

          ; get time

          time = sci_data[kk].time

          ; add to IF data set

          rcs_add_hspct, sc, vs, time, data, flag

       ENDFOR

       IF n_duff_points GT 0 THEN rcs_text, 'No. of points rejected containing fill values = '+rcs_strtrim(n_duff_points)

     ENDIF ELSE rcs_text, 'NO HSPCT SCI data :'+name, /OVERRIDE

    ENDIF ELSE rcs_text, 'SCI file does not exist', /OVERRIDE

  ENDIF

END
