;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_PROCESS_I3DD
;
; Purpose     : Reads and processes I3DD SCI data.
;
; Explanation : Reads and processes I3DD SCI data.
;
; Use         : < rcs_sci_process_i3dd, sc, day, use >
;
; Inputs      : use : STRUCTURE giving info on what IF data sets to cretae
;               sc  : STRING character giving S/C
;               day  : STRARR containing IF day name for processing.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 23/07/02
;
; Modified    : Version 0.1, 04/12/02
;                 Added OVERRIDE to 1st printout.
;               Version 0.2, 17/01/03
;                 Corrected bug where IES lut used instead of 0.
;               Version 0.3, 11/07/02
;                 Modified to allow gzipped SCI files.
;               Version 0.4, 03/09/03
;                 Changed to new version control.
;               Version 0.5, 16/09/03
;                 Added check for fill values.
;               Version 0.6, 17/10/03
;                 Improved check for fill values.
;               Version 0.7, 08/01/04
;                 Renamed rcs sw version.
;
; Version     : Version 0.7, 08/01/04
;-
;**********************************************************

PRO rcs_sci_process_i3dd, sc, day, use

  ; global common block

  COMMON rcs_i3dd_H_block, header_H, data_H

  COMMON rcs_i3dd_He_block, header_He, data_He

  COMMON rcs_i3dd_CNO_block, header_CNO, data_CNO

  ; get IIMS data

  IF KEYWORD_SET(use.i3dd) THEN BEGIN

    ; get i3dd raw count data

    name = rcs_sciname(sc,day,'I3DD','K','*')

    rcs_text, 'Reading file : '+name, /OVERRIDE

    ; test all files exist

    IF ies_file_exists(name) THEN BEGIN

      IF rcs_read_sci(name, i3dd_sci_head, i3dd_sci_data, i3dd_sci_samples ) THEN BEGIN

        rcs_text, 'Processing I3DD SCI data'

        ; get vs

        IF NOT KEYWORD_SET(i3dd_sci_head.cd_version) THEN rcs_message, /IMPLEMENTATION

        vs = rcs_if_version( SOURCE=rcs_get_source(), CD_VERSION=i3dd_sci_head.cd_version, SW_VERSION=ies_sw_version())

        ; check SC to determine accumulation time in secs

        IF sc EQ '2' THEN acc = 4.0 ELSE acc = 32.0

        ; get flags indicating fill values

        list = WHERE(NOT i3dd_sci_data.flag, count)

        ; set up no of points rejected due to fill values

        n_duff_points = i3dd_sci_head.npoints - count

        ; loop through samples

        FOR k = 0, count-1 DO BEGIN

          ; index into arrays

          kk = list[k]

          ; [12,8,3,16]

          i3dd = i3dd_sci_samples[i3dd_sci_data[kk].pos:i3dd_sci_data[kk].pos+i3dd_sci_data[kk].nvals-1]

          i3dd = REFORM(i3dd,12,8,3,16)

          ; get flag

          flag = 0

          ; get time

          time = i3dd_sci_data[kk].time

          ; make IF sets

          rcs_add_data, rcs_get_scname(sc)+'_IIMS_I3DD_H', sc, vs, 'I3DD_H', 'I-3DD H', 16, time, header_H, data_H, i3dd[*,*,0,*], 0, flag, acc

          rcs_add_data, rcs_get_scname(sc)+'_IIMS_I3DD_He', sc, vs, 'I3DD_He', 'I-3DD He', 16, time, header_He, data_He, i3dd[*,*,1,*], 0, flag, acc

          rcs_add_data, rcs_get_scname(sc)+'_IIMS_I3DD_CNO', sc, vs, 'I3DD_CNO', 'I-3DD CNO', 16, time, header_CNO, data_CNO, i3dd[*,*,2,*], 0, flag, acc

        ENDFOR

        IF n_duff_points GT 0 THEN rcs_text, 'No. of points rejected containing fill values = '+rcs_strtrim(n_duff_points)

     ENDIF ELSE rcs_text, 'NO I3DD SCI data :'+name, /OVERRIDE

    ENDIF ELSE rcs_text, 'SCI file does not exist', /OVERRIDE

  ENDIF

END
