;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_PROCESS_IPAD
;
; Purpose     :	Reads and processes IPAD SCI data.
;
; Explanation : Reads and processes IPAD SCI data.
;
; Use         : < rcs_sci_process_ipad, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples >
;
; Inputs      : use   : STRUCTURE giving info on what IF data sets to cretae
;               sc    : STRING character giving S/C
;               day   : STRARR containing IF day name for processing.
;               mdata_sci_head    : STRUCTURE mdata header information
;               mdata_sci_data    : STRUCTURE[] mdata info for each sample
;               mdata_sci_samples : FLOAT[] mdata data samples
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 23/07/02
;
; Modified    : Version 0.1, 04/12/02
;                 Added OVERRIDE to 1st printout.
;               Version 0.2, 17/01/03
;                 Removed unused lut_no.
;               Version 0.3, 11/07/02
;                 Modified to allow gzipped SCI files.
;               Version 0.4, 03/09/03
;                 Changed to new version control.
;               Version 0.5, 16/09/03
;                 Modified to pass mdata header, data and samples through argument list instead of
;                 just mdata.
;                 Added new mdata check.
;                 Added check for fill values.
;               Version 0.6, 17/10/03
;                 Improved check for fill values.
;               Version 0.7, 08/01/04
;                 Renamed rcs sw version.
;
; Version     : Version 0.7, 08/01/04
;-
;**********************************************************

PRO rcs_sci_process_ipad, sc, day, use, mdata_sci_head, mdata_sci_data, mdata_sci_samples

  ; get IPAD data

  IF KEYWORD_SET(use.ipad) THEN BEGIN

    ; get ipad raw count data

    name = rcs_sciname(sc,day,'IPAD','K','*')

    rcs_text, 'Reading file : '+name, /OVERRIDE

    ; test all files exist

    IF ies_file_exists(name) AND KEYWORD_SET(mdata_sci_head) THEN BEGIN

      IF rcs_read_sci(name, ipad_sci_head, ipad_sci_data, ipad_sci_samples ) THEN BEGIN

        rcs_text, 'Processing IPAD SCI data'

        ; check e3dd and mdata are compatible

        IF rcs_sci_check(ipad_sci_head, ipad_sci_data, ipad_sci_samples, $
           mdata_sci_head, mdata_sci_data, mdata_sci_samples) THEN rcs_message, /IMPLEMENTATION

        ; convert to mdata FLTARR(32,n) 16 m values + 16 msigns for each sample

        mdata = REFORM(mdata_sci_samples,32,mdata_sci_head.npoints)

        ; get vs

        IF NOT KEYWORD_SET(ipad_sci_head.cd_version) THEN rcs_message, /IMPLEMENTATION

        vs = rcs_if_version( SOURCE=rcs_get_source(), CD_VERSION=ipad_sci_head.cd_version, SW_VERSION=ies_sw_version())

        ; get flags indicating fill values

        flags = ipad_sci_data.flag OR mdata_sci_data.flag

        list = WHERE(NOT flags, count)

        ; set up no of points rejected due to fill values

        n_duff_points = ipad_sci_head.npoints - count

        ; loop through samples

        FOR k = 0, count-1 DO BEGIN

          ; index into arrays

          kk = list[k]

          ; set up mvals array

          mvals = rcs_reconstruct_mvals(mdata[*,kk])

          ; [3,8,3,16]

          ipad = ipad_sci_samples[ipad_sci_data[kk].pos:ipad_sci_data[kk].pos+ipad_sci_data[kk].nvals-1]

          ipad = REFORM(ipad,2,3,16)

          ; get flag

          flag = 0

          ; get time

          time = ipad_sci_data[kk].time

          rcs_ipad, ipad, time, sc, vs, mvals, flag

        ENDFOR

        IF n_duff_points GT 0 THEN rcs_text, 'No. of points rejected containing fill values = '+rcs_strtrim(n_duff_points)

      ENDIF ELSE rcs_text, 'NO IPAD SCI data :'+name, /OVERRIDE

    ENDIF ELSE rcs_text, 'IPAD or MDATA SCI file does not exist', /OVERRIDE

  ENDIF

END
