;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_PROCESS_MDATA
;
; Purpose     :	Reads and processes SCI MDATA data.
;
; Explanation : Reads and processes SCI MDATA data.
;
; Use         : < rcs_sci_process_mdata, sc, day, use, head, data, samples >
;
; Inputs      : use : STRUCTURE giving info on what IF data sets to create
;               sc  : STRING character giving S/C
;               day  : STRARR containing IF day name for processing.
;
; Opt. Inputs : None.
;
; Outputs     : head    : STRUCTURE header information
;               data    : STRUCTURE[] info for each sample
;               samples : FLOAT[] data samples
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 06/08/02
;
; Modified    : Version 0.1, 04/12/02
;                 Added OVERRIDE to 1st printout.
;               Version 0.2, 11/07/02
;                 Modified to allow gzipped SCI files.
;               Version 0.3, 16/09/03
;                 Modified to pass mdata header, data and samples through argument list.
;
; Version     :	Version 0.3, 16/09/03
;-
;**********************************************************

PRO rcs_sci_process_mdata, sc, day, use, head, data, samples

  head = 0
  data = 0
  samples = 0

  ; get MDATA data

  IF KEYWORD_SET(use.epad) OR KEYWORD_SET(use.epad2) OR $
     KEYWORD_SET(use.cleanbm) OR KEYWORD_SET(use.cleanbm2) $
     OR KEYWORD_SET(use.ipad) THEN BEGIN

    ; get mdata raw count data

    name = rcs_sciname(sc,day,'MDATA','K','*')

    rcs_text, 'Reading file : '+name, /OVERRIDE

    ; test all files exist

    IF ies_file_exists(name) THEN BEGIN

      IF NOT rcs_read_sci(name, head, data, samples ) THEN rcs_text, 'NO MDATA SCI data :'+name, /OVERRIDE

    ENDIF ELSE rcs_text, 'SCI file does not exist', /OVERRIDE

  ENDIF

END
