;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCI_THROWAWAY
;
; Purpose     :	Parses line in SCI file and throws away data.
;
; Explanation : Parses line in SCI file and throws away data.
;
; Use         : < res = rcs_sci_throwaway(unit, line) >
;
; Inputs      : unit   : LONG logical unti number for file
;               line   : STRING current line
;
; Opt. Inputs : None.
;
; Outputs     : res : INT FLAG indicating success of operation.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 01/08/02
;
; Modified    : Version 0.1, 17/07/03
;                 Changed to function to allow error return.
;                 Changed to return on IO error.
;
; Version     :	Version 0.1, 17/07/03
;-
;**********************************************************

FUNCTION rcs_sci_throwaway, unit, line

  ON_IOERROR, ioerror

  rcs_text, '> code : '+line

  ; letter code for throwaway sample

  ; set current sample state

  vals = rcs_strsplit(line)

  nvals = LONG(vals[1])

  ; read values

  WHILE nvals GT 0 DO BEGIN

    READF, unit, line

    ; check if blank letter code for current line
    ; ie is part of a data sample

    IF NOT rcs_strstart(line,' ') THEN rcs_message, /IMPLEMENTATION

    vals = rcs_strsplit(line,/FLOAT)

    nvals = nvals - N_ELEMENTS(vals)

  ENDWHILE

  ; check sample is finished correctly

  IF nvals NE 0 THEN rcs_message, /IMPLEMENTATION

  RETURN, 1

ioerror : RETURN, rcs_sci_ioerror(unit)

END
