;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCINAME
;
; Purpose     :	Returns SCI file name.
;
; Explanation : Returns SCI file name.
;
; Use         : < file = rcs_sciname(sc,day,class,suffix,postfix) >
;
; Inputs      : sc     : STRING character S/C
;               day    : STRING day in form yymmdd
;               class  : STRING class i.e 'ESPCT'
;               suffix : STRING suffix giving type of data i.e 'K' for raw counts
;               postfix: STRING postfix giving file extension ie 'SCI', '*' or 'gz'
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : PATH : FLAG indicating should return directory only
;               FILE : FLAG indicating should return file name only
;
; Written     :	Version 0.0, 08/07/02
;
; Modified    : Version 0.1, 03/09/02
;                 Used separate environment variable for SCI DATA DIRECTORY.
;               Version 0.2, 11/03/03
;                 Added postfix argument to allow gzipped files.
;               Version 0.3, 11/07/03
;                 Removed 'SCI' explicit file extension. If needed this should be incorporated into postfix.
;                 This allows for PC case where gzipping file replaces 'SCI' file extension with 'gz'.
;               Version 0.4, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.4, 09/10/03
;-
;**********************************************************

FUNCTION rcs_sciname, sc, day, class, suffix, postfix, PATH=path, FILE=file

  IF NOT KEYWORD_SET(file) THEN BEGIN

    ; get root directory

    root = ies_get_dir('SCI_DATA',/RAPID)

    ; only use first of multiple directories

    roots = break_path(root,/NOCURRENT)

    root = roots[0]

    directory = concat_dir (root,'C'+sc+'_SCI')

    IF KEYWORD_SET(path) THEN RETURN, directory

  ENDIF

  IF STRLEN(day) EQ 6 THEN tday = rcs_to_yyyymmdd(day) ELSE tday = day

  name = 'C'+sc+'_'+tday+'_'+class

  IF KEYWORD_SET(suffix) THEN name = name+'_'+suffix

  IF KEYWORD_SET(postfix) THEN name = name+'.'+postfix

  IF KEYWORD_SET(file) THEN RETURN, name

  ; get full filename

  RETURN, concat_dir(directory,name)

END
