;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SCINAME_SC
;
; Purpose     :	Gets SC from SCI filename.
;
; Explanation : Gets SC from SCI filename.
;
; Use         : < sc = rcs_sciname_sc(name) >
;
; Inputs      : name : STRING SCI data set name
;
; Opt. Inputs : None.
;
; Outputs     : sc : STRING character giving S/C
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 04/07/02
;
; Modified    : None.
;
; Version     :	Version 0.0, 04/07/02
;-
;**********************************************************

FUNCTION rcs_sciname_sc, name

  ; get filename

  sciname = strip_dirname(name)

  IF STRLEN(sciname) LT 15 THEN GOTO, error

  sc = STRMID(sciname,1,1)

  RETURN, sc

  error : rcs_message, 'INVALID SCI NAME', /INFORMATIONAL

  RETURN, ''

END
