; 10/07/02 : Use droutine ies_get_colors

PRO data_plot, header, data, DST=dst, t0=t0, t1=t1, RANGE=range, $
               WINDOWS=windows, POSTSCRIPT=postscript, GIF=gif, BWPS=bwps, $
               LANDSCAPE=landscape, PORTRAIT=portrait, $
               DRANGE=drange, TITLE=title, ENERGIES=energies, DETECTOR=detector

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0

  xmargin = [7,12]
  ymargin = [0,1]

  ; set display range defaults

  IF NOT KEYWORD_SET(range) THEN range = [1e2,1e7]

  IF NOT KEYWORD_SET(energies) THEN energies = INDGEN(header.nbands)

  IF NOT KEYWORD_SET(detector) THEN detector = 0

  IF NOT KEYWORD_SET(title) THEN title=''

  ; get time range

  time_start = header.tstart
  time_end   = header.tstop

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  ; test output device

  IF KEYWORD_SET(windows) THEN BEGIN

    WINDOW, /FREE, XSIZE=1200, YSIZE=256*nplots+100

  ENDIF ELSE IF KEYWORD_SET(postscript) THEN BEGIN

    IF datatype(postscript) NE 'STR' THEN BEGIN
      file=PICKFILE(TITLE='Select file for POSTSCRIPT output',FILTER='*.ps', PATH=ies_get_dir('PS',/POLAR) )
    ENDIF ELSE file = postscript

    IF file EQ '' THEN BEGIN
      MESSAGE, 'No data file given', /CONT, /TRACEBACK
      RETURN
    ENDIF

    ; check if has directory defined

    IF STRLEN(strip_dirname(file)) EQ STRLEN(file) THEN file = concat_dir(ies_get_dir('PS',/POLAR),file)

    SET_PLOT, 'PS'

    IF KEYWORD_SET(portrait) THEN BEGIN
      DEVICE, /COLOR, BITS=8, FILE=file, XOFFSET=0.6, YOFFSET=0.5, XSIZE=19.9, YSIZE=26.5, /PORTRAIT
    ENDIF ELSE BEGIN
      DEVICE, FILE=file, BITS=8, /LANDSCAPE, /COLOR, XOFFSET=0.5, YOFFSET=27.5, XSIZE=27, YSIZE=19.9
    ENDELSE

    ; fix color table

    LOADCT, 39

  ENDIF ELSE WINDOW,/FREE

  !P.MULTI=0
  !P.CHARSIZE = 1
  !P.REGION = [ 0.0, 0, 1.0, 1]
  !P.POSITION = 0

  ; plot title

  XYOUTS, 0.5, 0.96, title, $
          ALIGNMENT=0.5, CHARSIZE=1.5, /NORMAL

  ; plot data

  nplots = N_ELEMENTS(energies)
  IF KEYWORD_SET(dst) THEN nplots = nplots + 1
  pos = 0.95
  size = 0.9/nplots

  ; get band energy
  ; select energies corresponding to first look up table, first detector

  IF ies_tag_exists(header,'ENERGY_CAL') THEN $
    energy_cal = header.energy_cal ELSE $
    energy_cal = 1

  energy_bands = header.ch_positions[*,*,detector,data[0].lut]*energy_cal[0]
  IF N_ELEMENTS(energy_cal) GT 1 THEN energy_bands = energy_bands + energy_cal[1]

  energy_bands = REFORM(STRTRIM(STRING(FORMAT='(I)',energy_bands),2),2,header.nbands)

  ; loop through energies

  FOR p = 0, N_ELEMENTS(energies)-1 DO BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set x axis flag

    no_xaxis = p NE (nplots-1)

    ; set up axes

    ies_do_axes, time_start, time_end, range[0], range[1], xmargin, ymargin, /ylog, $
      XTITLE='Time', YTITLE=ies_ctitle(header), NO_XAXIS=no_xaxis, /NO_ERASE

    ; get color for overlay

    col = ies_get_colors(p)

    OPLOT, data.time-time_start, data.data[0,detector,energies[p]], COLOR=col

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

    ; put down labels
    ; NB the different energy bands correspond to the ytitle

    ies_do_labels, 1, $
      energy_bands[0,energies[p]]+':'+energy_bands[1,energies[p]], $
      CTITLE='keV', NO_XAXIS=no_xaxis

  ENDFOR

  ; dst

  IF N_ELEMENTS(dst) GT 0 THEN BEGIN

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF NOT KEYWORD_SET(drange) THEN drange = [-150,20]

    ; set up axes

    ies_do_axes, time_start, time_end, drange[0], drange[1], xmargin, ymargin, $
      XTITLE='Time', YTITLE='Dst index', $
      /NO_ERASE, OVERLAY=overlay

    ; plot Dst index

    OPLOT, dst.time-time_start, dst.dst

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  IF KEYWORD_SET(postscript) THEN BEGIN
    DEVICE, /CLOSE
    SET_PLOT, devname
  ENDIF

END