; finds last close field line
; plots in data
; plots last closed field line form map
; plots flux envelope

PRO do_lcfl, time, data, map

  ; time DBLARR(l+1,norbits,npoints)
  ; data FLTARR(l,norbits*npoints)
  ; map  struct(norbits,nsamples)

  nl = (SIZE(time))[1]-1
  no = (SIZE(time))[2]
  ns = (SIZE(time))[3]

  pairs = REPLICATE(-1.0,3,no,ns)

  FOR o = 0, no-1 DO BEGIN

    FOR s = 0, ns-1 DO BEGIN

      ; find led corresponding to flux 1e5

      lllist = WHERE(data[*,o*ns+s] GE 1e5, lll_count)

      IF lll_count GT 0 THEN BEGIN

        pairs[1,o,s] = lllist[lll_count-1]/10. ; pair[1] is led of flux threshold

        ; get Dst

        pairs[2,o,s] = (get_parmod(time[lllist[lll_count-1],o,s],/DST))[1]

        ; fix data

        ;data[lllist[lll_count-1],o*ns+s] = 1e8

      ENDIF

    ENDFOR

  ENDFOR

  FOR k = 0, N_ELEMENTS(map)-1 DO BEGIN

;     cr = map[k].lphi

    fl = map[k].flag[0,*].ofl OR map[k].flag[0,*].hes OR map[k].flag[0,*].na OR map[k].flag[0,*].nk

    ; NB hes is not relevant for drift shell

    ds = map[k].flag[1,*].ofl OR map[k].flag[1,*].na OR map[k].flag[1,*].nk

    cr = 1-(fl OR ds)

    list = WHERE ( cr NE 0, count)

    IF count GT 0 THEN BEGIN

      led = MAX(map[k].led[list],pos)

      tpos = map[k].time[list[pos]]

      ; now find sample in data corresponding to tpos

      list = WHERE((time[nl,*,*] LE tpos AND time[0,*,*] GE tpos) OR $
                   (time[nl,*,*] GE tpos AND time[0,*,*] LE tpos), count)

      IF count EQ 1 THEN BEGIN

        ltime = time[*,list[0] MOD no, list[0]/no]

        llist = WHERE((ltime[1:*] LE tpos AND ltime GE tpos) OR $
                      (ltime[1:*] GE tpos AND ltime LE tpos), count)

        ; IF ABS(llist[0]/10.-led) GT 0.2 THEN STOP

        pairs[0,list[0] MOD no, list[0]/no] = llist[0]/10.  ; pair[0] is Led of lcfl

        ; fix data

        IF count EQ 1 THEN data[llist[0],list[0]] = 0

      ENDIF

    ENDIF

  ENDFOR

END