; /YYYY keyword indicates filenames have form yyyymmdd rather than default yymmdd

FUNCTION test_yyyymmdd, yyyymmdd

  ; error handler

  ON_IOERROR, error

  FOR k=0,STRLEN(yyyymmdd)-1 DO dummy = FIX(STRMID(yyyymmdd,k,1))

  RETURN, 1

  error : RETURN, 0

END
  
PRO check_consecutive, files, YYYY=yyyy

  ; sort files 

  list = rcs_sort_days(strip_dirname(files), DAYS=days, YYYY=yyyy)

  ; loop through files

  count = 0

  start_day = ''

  end_day = ''

  FOR f = 0, N_ELEMENTS(list)-1 DO BEGIN

    ; extract yyyymmdd

    yyyymmdd = days[list[f]]

    IF test_yyyymmdd(yyyymmdd) THEN BEGIN

      count = count + 1

      year = FIX(STRMID(yyyymmdd,0,4))

      mm = FIX(STRMID(yyyymmdd,4,2))

      dd = FIX(STRMID(yyyymmdd,6,2))

      ext = {year:year,month:mm,day:dd,hour:0,minute:0,second:0,millisecond:0}

      utc = anytim2utc(ext)

      jul = utc.mjd

      IF KEYWORD_SET(previous_jul) THEN BEGIN

        IF jul GT previous_jul+1 THEN BEGIN

          FOR j = previous_jul+1, jul-1 DO BEGIN

            utc.mjd = j

            PRINT, 'Missing : ', anytim2cal(utc,/DATE)

          ENDFOR

        ENDIF ELSE IF jul LT previous_jul THEN MESSAGE, 'IMPLEMENTATION ERROR'
   
      ENDIF ELSE start_day = yyyymmdd

      previous_jul = jul

      end_day = yyyymmdd

    ENDIF ELSE print,yyyymmdd

  ENDFOR

  PRINT, 'Files ', N_ELEMENTS(files), count, ' ', start_day, ' ', end_day

END

PRO remove_files, files

  FOR f = 0, N_ELEMENTS(files)-1 DO BEGIN

    ; get filename 

    filename = strip_dirname(files[f])

  ;  IF STRLEN(filename) EQ 10 THEN SPAWN,'rm -ef '+files[f]
    SPAWN,'rm -ef '+files[f]

  ENDFOR

END

PRO process_directory, directory, FILTER=filter, YYYY=yyyy, REMOVE=remove
 
  ; NB concat_dir does not care if directory name has slash after or not
  ; get list of files in directory

  IF NOT KEYWORD_SET(filter) THEN filter = '*.*'

  files = FINDFILE(concat_dir(directory,filter),COUNT = count)

  IF count EQ 0 THEN RETURN

  IF KEYWORD_SET(remove) THEN remove_files, files $
  ELSE check_consecutive, files, YYYY=yyyy

END

PRO files, FILTER=filter, YYYY=yyyy, REMOVE=remove

  ; select toplevel directory
  ; under Unix DIALOG_PICKFILE returns a / after directory name

  directories = DIALOG_PICKFILE(TITLE='Specify directory', /DIRECTORY)

  IF NOT KEYWORD_SET(directories) THEN RETURN

  ; recurse through sub-directories

  going = 1

  WHILE going DO BEGIN  

    PRINT, 'Directory=',directories[0]

    process_directory, directories[0], FILTER=filter, YYYY=yyyy, REMOVE=remove

    subs = rcs_find_subdirs(directories[0])

    IF N_ELEMENTS(directories) GT 1 THEN BEGIN

      IF KEYWORD_SET(subs) THEN directories = [subs,directories[1:*]] $
                           ELSE directories = directories[1:*]
  
    ENDIF ELSE BEGIN

      IF KEYWORD_SET(subs) THEN directories = subs ELSE going = 0

    ENDELSE

  ENDWHILE

END