; map contains :
;   predicted B  field at no. of points
;   predicted Bm field at no. of points for fixed K
;   L phi value at no. of points
;   L ed  value at no. of points
;
;   fix_lphi uses map.b0, map.bm, map.time
;   previously used .lsh which indicates that K integral can be performed at this point
;   change to use valid Bm as criterion for map valid

; pa contains :
;   coefficients for a.SIN^b fit to pitch angle distribution at each L point for each energy

; mf contains :
;   measured B field at each L point

; SW :
;    Compares predicted B field with measured B field
;    Works out pitch angle corresponding to Bm at fixed K.
;    Calculates energy to give fixed M at Bm
;    Selects closest energies to this energy.
;    Calculates flux at these energies and pitch angle.
;    Interpolates flux to required energy at required pitch angle.
;    Calculates phase space density at required energy and pitch angle.

; derives cts/keV at fixed value of M 
; expects cts rather than cts/keV

; has problems at present if lpoints=200 for data 

; /RESIDUALS : Just calculates residuals from measured B field
; /PITCH : Assumes non-isotropic distribution, use ies_pa rather than ies for example


FUNCTION fix_lphi, mf, data, map, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1, $
         MOM=mom, ASK=ask, PITCH=pitch, RESIDUALS=residuals, RELATIVISTIC=relativistic

  IF NOT KEYWORD_SET(ask) THEN ask = 0

  ch = lsh_get_energies(INST=inst, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1)

  ; get channel sizes

  sz = REFORM(ch[1,*]-ch[0,*])

  ; get mean channel energies

  en = TOTAL(ch[*,e0:e1],1)/2

  nlsh = MIN([(SIZE(mf.data))[2],(SIZE(data.data))[2]])

  IF NOT KEYWORD_SET(residuals) THEN BEGIN

    IF NOT EXECUTE ( 'struct={' + inst + '_MAP_'+STRTRIM((SIZE(map.bm))[1],2)+'_V1,' + $
                     'time:DBLARR(nlsh+1),'+ $
                     'data:FLTARR(1,nlsh) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
     
    output = REPLICATE ( struct, (SIZE(data))[1], (SIZE(data))[2] ) 

    output.time = data.time[0:nlsh]

    output.data = -1
 
  ENDIF ELSE BEGIN

    IF NOT EXECUTE ( 'struct={' + inst + '_RESIDUAL_'+STRTRIM((SIZE(map.bm))[1],2)+'_V0,' + $
                     'time:DBLARR(nlsh+1),'+ $
                     'data:FLTARR(1,nlsh) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
     
    output = REPLICATE ( struct, (SIZE(data))[1], (SIZE(data))[2] ) 

    output.time = data.time[0:nlsh]

    output.data = 0

  ENDELSE

  IF NOT KEYWORD_SET(mom) THEN BEGIN
     mom = 1
    IF KEYWORD_SET(ies) THEN mom = 0.1 ; kev/nT
    IF KEYWORD_SET(histe) THEN mom = 3.0 ; kev/nT
  ENDIF

  ; loop over parts of orbit

  FOR p = 0, (SIZE(data))[1]-1 DO BEGIN 

    ; get orbits where have both particle and magnetic field data

    mlist = [0]
    dlist = [0]

    FOR k = 0, (SIZE(data))[2]-1 DO BEGIN

      ls = WHERE( (data[p,k].time[nlsh/2] GE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] LE mf[p,*].time[nlsh]) OR $
                  (data[p,k].time[nlsh/2] LE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] GE mf[p,*].time[nlsh]),count)

      IF count EQ 1 THEN BEGIN
       mlist = [mlist,ls]
       dlist = [dlist,k]
      ENDIF
    
    ENDFOR

    PRINT, 'MF Matches = ', p, N_ELEMENTS(mlist)-1

    IF N_ELEMENTS(mlist) GT 1 THEN BEGIN

      mlist = mlist[1:*]
      dlist = dlist[1:*]

      ; get no of map points

      nmap = (SIZE(map.b0))[1]

      ; get orbits where also have map data

      blist = [0]
      clist = [0]

      FOR k = 0, N_ELEMENTS(dlist)-1 DO BEGIN

        ls = WHERE( (data[p,dlist[k]].time[nlsh/2] GE map[p,*].time[0] AND $
                     data[p,dlist[k]].time[nlsh/2] LE map[p,*].time[nmap-1]) OR $
                    (data[p,dlist[k]].time[nlsh/2] LE map[p,*].time[0] AND $
                     data[p,dlist[k]].time[nlsh/2] GE map[p,*].time[nmap-1]),count)

        IF count EQ 1 THEN BEGIN
          blist = [blist,ls]
          clist = [clist,k]
        ENDIF
    
      ENDFOR

      PRINT, 'MAP Matches = ', p, N_ELEMENTS(blist)-1

      IF N_ELEMENTS(blist) GT 1 THEN BEGIN

        blist = blist[1:*]         ; orbits  for map data
        dlist = dlist[clist[1:*]]  ; orbits for particle data
        mlist = mlist[clist[1:*]]  ; orbits for magnetic field data

        FOR k = 0, N_ELEMENTS(mlist)-1 DO BEGIN

          ; get local copies of map, magnetic field and particle data for current orbit
          ; divide particle data by energy channel sizes

          mmap = map[p,blist[k]]
          mmf  = mf[p,mlist[k]]

          IF KEYWORD_SET(pitch) THEN BEGIN

            ; get dat as FLTARR[nenergies,2,nlpoints]
            ; have pa pair for each sample, energy, lpoint

            dat = data[p,dlist[k]].data
            dat = REFORM(dat,(SIZE(dat))[1]/2,2,(SIZE(dat))[2])
            dat[*,0,*] = dat[*,0,*]/(sz#REPLICATE(1,(SIZE(dat))[3])) 

          ENDIF ELSE BEGIN

            ; get dat as FLTARR[nenergies,nlpoints]

            dat = data[p,dlist[k]].data

            dat = dat/(sz#REPLICATE(1,(SIZE(dat))[2])) 

          ENDELSE

          ; get time for each particle data lpoint as DBLARR[1+nlpoints]

          tim = (data[p,dlist[k]].time[1:*]+data[p,dlist[k]].time)/2.

          ; remove end points which all have the same time

          list = WHERE(tim[1:*] NE tim, count)

          IF count GE 2 THEN BEGIN

            list = [list,list[count-1]+1]

            ; get list of where map data valid 

            vlist = WHERE(mmap.bm GT 0, count)

            IF count GT 1 THEN BEGIN

              ; get list of lpoints with valid map

              llist = WHERE (tim[list] GE mmap.time[vlist[0]] AND tim[list] LE mmap.time[vlist[count-1]], count)

              IF count GT 0 THEN BEGIN

                list = list[llist]

                ; get predicted Bfield at lpoint times

                b0 = INTERPOL(mmap.b0[vlist], mmap.time[vlist], tim) 

                ; plot valid predicted and measured bfield 

                PLOT, tim[list]-tim[0], b0[list], COLOR=100, /YLOG, YRANGE=[1e2,1e4], $
                  XRANGE=[MIN(tim[[0,nlsh]])-tim[0],MAX(tim[[0,nlsh]])-tim[0]], $
                  TITLE = anytim2cal(tim[0])

                OPLOT, mmap.time[vlist]-tim[0], mmap.b0[vlist], COLOR=100, PSYM=2

                OPLOT, (mmf.time[1:*]+mmf.time)/2-tim[0], mmf.data[0,*], COLOR=200, PSYM=4

                ; get predicted Bmirror at fixed K at lpoint times

                bm = INTERPOL(mmap.bm[vlist], mmap.time[vlist], tim) 

                ; plot valid mirror bfields

                OPLOT, tim[list]-tim[0], bm[list]
                OPLOT, mmap.time[vlist]-tim[0], mmap.bm[vlist], PSYM=1

                IF KEYWORD_SET(residuals) THEN BEGIN

                  ; get list of valid MFE data

                  mmf_list = WHERE(mmf.data[0,*] GT 1, mmf_count)

                  IF mmf_count GT 0 THEN BEGIN

                    mmf_time = (mmf.time[1:*]+mmf.time)/2  

                    mb = interp ( mmf_time[mmf_list], mmf.data[0,mmf_list],tim,/ENDS)   

                    OPLOT, tim[list]-tim[0], mb[list], COLOR=200

                    OPLOT, tim[list]-tim[0], 100*ABS(b0[list] - mb[list]), PSYM=1

                    ; save % residuals = interpolated predicted - interpolated measured
    
                    output[p,dlist[k]].data[0,list] = (b0[list] - mb[list])/mb[list] 

                  ENDIF                           

                ENDIF ELSE IF KEYWORD_SET(pitch) THEN BEGIN

                  ; get pitch angle at new bfield

                  bratio = b0/bm
  
                  llist = WHERE(bratio[list] LE 1, count)
                 
                  IF count GT 0 THEN BEGIN
 
                    list = list[llist]

                    OPLOT, tim[list]-tim[0], bm[list], COLOR=200

                    pitch = ASIN(SQRT(bratio<1))
  
                    ; get energy in keV corresponding to fixed mag moment = mom at each l point

                    energies = mom*bm

                    ; make relativistic
 
                    IF KEYWORD_SET(relativistic) THEN energies = 511.*(SQRT(1+2*energies/511.)-1)

                    ; check energy present
  
                    llist = WHERE(energies[list] GE en[0] AND energies[list] LT en[e1-e0], count)

                    IF count GT 0 THEN BEGIN

                      list = list[llist]

                      OPLOT, tim[list]-tim[0], bm[list], COLOR=100
  
                      ; loop over l points

                      FOR l = 0, count-1 DO BEGIN

                        ; index into lpoints
  
                        ll = list[l]

                        ; propagate energies above and below along field line

                        e_below = (WHERE(en LE energies[ll],ecount))[ecount-1] 
                        e_above = (WHERE(en GT energies[ll]))[0]  

                        sinfit, pitch[ll], dat[e0+e_below,*,ll], f_below
                        sinfit, pitch[ll], dat[e0+e_above,*,ll], f_above

                        ; interpolate to get data at required energy

                        f = INTERPOL ( [f_below,f_above], en[[e_below, e_above]], energies[ll] )

                        ; get phase space density

                        output[p,dlist[k]].data[0,ll] = f / energies[ll] 

                      ENDFOR

                    ENDIF

                  ENDIF

                ENDIF ELSE BEGIN

                  ; assume isotropic distribution
  
                  ; get energy in keV corresponding to fixed mag moment = mom at each l point

                  energies = mom*bm

                  ; make relativistic
 
                  IF KEYWORD_SET(relativistic) THEN energies = 511.*(SQRT(1+2*energies/511.)-1)

                  ; check energy present
  
                  llist = WHERE(energies[list] GE en[0] AND energies[list] LT en[e1-e0], count)

                  IF count GT 0 THEN BEGIN

                    list = list[llist]

                    OPLOT, tim[list]-tim[0], bm[list], COLOR=100
  
                    ; loop over l points

                    FOR l = 0, count-1 DO BEGIN

                      ; index into lpoints
  
                      ll = list[l]

                      ; propagate energies above and below along field line

                      e_below = (WHERE(en LE energies[ll],ecount))[ecount-1] 
                      e_above = (WHERE(en GT energies[ll]))[0]  

                      f_below = dat[e0+e_below,ll]
                      f_above = dat[e0+e_above,ll]

                      ; interpolate to get data at required energy

                      f = INTERPOL ( [f_below,f_above], en[[e_below, e_above]], energies[ll] )

                      ; get phase space density

                      output[p,dlist[k]].data[0,ll] = f / energies[ll] 

                    ENDFOR

                  ENDIF

                ENDELSE

              ENDIF

            ENDIF

          ENDIF

          IF ask THEN IF GET_KBRD(1) EQ 's' THEN ask = 0

        ENDFOR

      ENDIF

    ENDIF

  ENDFOR

  RETURN, output

END