; derives cts/keV at fixed value of M 
; expects cts rather than cts/keV


FUNCTION fix_mag, mf, data, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1, MOM=mom

  ch = lsh_get_energies(INST=inst, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1)

  ; get channel sizes

  sz = REFORM(ch[1,e0:e1]-ch[0,e0:e1])

  ; get mean channel energies

  en = TOTAL(ch[*,e0:e1],1)/2

  nlsh = (SIZE(data.data))[2]

  IF NOT EXECUTE ( 'struct={' + inst + '_MAGNETIC_MOMENT_V0,' + $
                   'time:DBLARR(nlsh+1),'+ $
                   'data:FLTARR(1,nlsh) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
  
  output = REPLICATE ( struct, (SIZE(data))[1], (SIZE(data))[2] ) 

  output.time = data.time

  IF NOT KEYWORD_SET(mom) THEN mom = 0.2

  FOR p = 0, (SIZE(data))[1]-1 DO BEGIN 

    ; get corresponding times

    mlist = [0]
    dlist = [0]

    FOR k = 0, (SIZE(data))[2]-1 DO BEGIN

      IF data[p,k].time[0] LT data[p,k].time[nlsh] THEN $
        ls = WHERE(data[p,k].time[nlsh/2] GE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] LE mf[p,*].time[nlsh],count) $
      ELSE $
        ls = WHERE(data[p,k].time[nlsh/2] LE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] GE mf[p,*].time[nlsh],count)

      IF count EQ 1 THEN BEGIN
       mlist = [mlist,ls]
       dlist = [dlist,k]
      ENDIF
    
    ENDFOR

    PRINT, 'Matches = ', p, N_ELEMENTS(mlist)-1

    IF N_ELEMENTS(mlist) GT 1 THEN BEGIN

      mlist = mlist[1:*]
      dlist = dlist[1:*]

      FOR k = 0, N_ELEMENTS(mlist)-1 DO BEGIN

        energies = REFORM(mom*mf[p,mlist[k]].data)  

        ; make relativistic
 
        energies = 511.*(SQRT(1+2*energies/511.)-1)

        dat = data[p,dlist[k]].data[e0:e1,*]/(sz#REPLICATE(1,200))

        ; for each L get flux at energies

        list = WHERE(energies GE en[0] AND energies LE en[e1-e0], count)

        FOR kk = 0, count-1 DO BEGIN

          ; plot phase space density

          output[p,dlist[k]].data[0,list[kk]] = INTERPOL(dat[*,list[kk]], en, energies[list[kk]]) $ 
                                                / energies[list[kk]] 

        ENDFOR

      ENDFOR

    ENDIF

  ENDFOR

  RETURN, output

END