; expects cts rather than cts/keV
; selects pitch angle to give constant bfield at each L

FUNCTION fix_pa, mf, data, pa

  nlsh = (SIZE(data.data))[2]

  IF NOT EXECUTE ( 'struct={' + inst + '_PITCH_ANGLE_V3,' + $
                   'time:DBLARR(nlsh+1),'+ $
                   'data:FLTARR((SIZE(data.data))[1]/2,nlsh) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
     
  output = REPLICATE ( struct, (SIZE(data))[1], (SIZE(data))[2] ) 

  output.time = data.time

  FOR p = 0, (SIZE(data))[1]-1 DO BEGIN 

    ; get corresponding times

    mlist = [0]
    dlist = [0]

    FOR k = 0, (SIZE(data))[2]-1 DO BEGIN

      IF data[p,k].time[0] LT data[p,k].time[nlsh] THEN $
        ls = WHERE(data[p,k].time[nlsh/2] GE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] LE mf[p,*].time[nlsh],count) $
      ELSE $
        ls = WHERE(data[p,k].time[nlsh/2] LE mf[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] GE mf[p,*].time[nlsh],count)

      IF count EQ 1 THEN BEGIN
       mlist = [mlist,ls]
       dlist = [dlist,k]
      ENDIF
    
    ENDFOR

    PRINT, 'Matches = ', p, N_ELEMENTS(mlist)-1

    IF N_ELEMENTS(mlist) GT 1 THEN BEGIN

      mlist = mlist[1:*]
      dlist = dlist[1:*]

      ; invalid value is currently <=1 

      list = WHERE(mf[p,mlist].data[0,50] GT 1, count)

      IF count EQ 0 THEN MESSAGE, 'Invalid B field'

      mlist = mlist[list]
      dlist = dlist[list]

      ; get bfield at each L value 

      bfield = FLTARR(nlsh)

      ; FOR l = 0, nlsh-1 DO bfield[l] = MAX(mf[*,mlist].data[0,l]) ; all parts of orbit

      FOR l = 0, nlsh-1 DO bfield[l] = MAX(mf[p,mlist].data[0,l]) ; single part of orbit

      ; bfield = REFORM(TOTAL(mf[p,mlist].data[0,0:nlsh-1],4))/count ; average bfield

      bfield = bfield#REPLICATE(1,count)

      bratio = REFORM(mf[p,mlist].data[0,0:nlsh-1])/(bfield>1)

      pitch = ASIN(SQRT(bratio))

      FOR k = 0, N_ELEMENTS(mlist)-1 DO BEGIN

        ; get dat as FLTARR[nenergies,2,nlpoints]
        ; have pa pair for each sample, energy, lpoint

        dat = data[p,dlist[k]].data
        dat = REFORM(dat,(SIZE(dat))[1]/2,2,(SIZE(dat))[2])

        FOR e = 0,(SIZE(dat))[1]-1 DO BEGIN

          FOR l = 0,nlsh-1 DO BEGIN

            sinfit, pitch[l,k], dat[e,*,l], f

            output[p,dlist[k]].data[e,l] = f

          ENDFOR

        ENDFOR

      ENDFOR

    ENDIF

  ENDFOR

  RETURN, output

END