; map contains :
;   predicted B field at no. of points
;   predicted B field at no. of points at SAMPEX altitude along same field line
;   L phi value at no. of points
;   L ed  value at no. of points

; data contains pa data :
;   coefficients for a.SIN^b fit to pitch angle distribution at each L point for each energy

; SW :
;    Works out pitch angle corresponding to Bs at SAMPEX.
;    Calculates flux at all energies for this pitch angle.

; derives cts/keV at fixed value of M 
; expects cts rather than cts/keV

FUNCTION fix_sampex, data, map, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, ASK=ask

  IF NOT KEYWORD_SET(ask) THEN ask = 0

  ; get inst

  dummy = lsh_get_energies(INST=inst, IES=ies, IPS=ips, HISTE=histe, HISTP=histp)

  nlsh = (SIZE(data.data))[2]

  IF NOT EXECUTE ( 'struct={' + inst + '_MAP_SAMPEX_'+STRTRIM((SIZE(map.bm))[1],2)+'_V0,' + $
                   'time:DBLARR(nlsh+1),'+ $
                   'data:FLTARR((SIZE(data.data))[1]/2,nlsh) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
     
  output = REPLICATE ( struct, (SIZE(data))[1], (SIZE(data))[2] ) 

  output.time = data.time

  output.data = -1

  FOR p = 0, (SIZE(data))[1]-1 DO BEGIN 

    ; get no of map points

    nmap = (SIZE(map.b0))[1]

    ; get corresponding times

    mlist = [0]
    dlist = [0]

    FOR k = 0, (SIZE(data))[2]-1 DO BEGIN

      ls = WHERE( (data[p,k].time[nlsh/2] GE map[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] LE map[p,*].time[nmap-1]) OR $
                  (data[p,k].time[nlsh/2] LE map[p,*].time[0] AND $
                   data[p,k].time[nlsh/2] GE map[p,*].time[nmap-1]),count)

      IF count EQ 1 THEN BEGIN
        mlist = [mlist,ls]
        dlist = [dlist,k]
      ENDIF
    
    ENDFOR

    PRINT, 'MAP Matches = ', p, N_ELEMENTS(dlist)-1

    IF N_ELEMENTS(dlist) GT 1 THEN BEGIN

      mlist = mlist[1:*]
      dlist = dlist[1:*]

      FOR k = 0, N_ELEMENTS(mlist)-1 DO BEGIN

        ; get local copies

        mmap = map[p,mlist[k]]

        ; get dat as FLTARR[nenergies,2,nlpoints]
        ; have pa pair for each sample, energy, lpoint

        dat = data[p,dlist[k]].data
        dat = REFORM(dat,(SIZE(dat))[1]/2,2,(SIZE(dat))[2])

        ; get time for each lpoint as DBLARR[1+nlpoints]

        tim = (data[p,dlist[k]].time[1:*]+data[p,dlist[k]].time)/2.

        ; remove end points which all have the same time

        list = WHERE(tim[1:*] NE tim, count)

        IF count GE 2 THEN BEGIN

          list = [list,list[count-1]+1]

          ; get list of valid map data

          vlist = WHERE(mmap.bs GT 0, count)

          IF count GT 1 THEN BEGIN

            ; get list of lpoints with valid map

            llist = WHERE (tim[list] GE mmap.time[vlist[0]] AND tim[list] LE mmap.time[vlist[count-1]], count)

            IF count GT 0 THEN BEGIN

              list = list[llist]

              ; get predicted Bfield at lpoint times

              b0 = INTERPOL(mmap.b0[vlist], mmap.time[vlist], tim) 

              ; plot valid predicted bfield 

              PLOT, tim[list]-tim[0], b0[list], COLOR=100, /YLOG, YRANGE=[1e0,1e5], $
                XRANGE=[MIN(tim[[0,nlsh]])-tim[0],MAX(tim[[0,nlsh]])-tim[0]], $
                TITLE = anytim2cal(tim[0])

              OPLOT, mmap.time[vlist]-tim[0], mmap.b0[vlist], COLOR=100, PSYM=2

              ; get predicted SAMPEX B at lpoint times

              bs = INTERPOL(mmap.bs[vlist], mmap.time[vlist], tim) 

              ; plot valid SAMPEX bfields

              OPLOT, tim[list]-tim[0], bs[list]
              OPLOT, mmap.time[vlist]-tim[0], mmap.bs[vlist], PSYM=1

              ; get pitch angle at new bfield

              bratio = b0/(bs>1)

              llist = WHERE(bratio[list] LE 1, count)

              IF count GT 0 THEN BEGIN
 
                list = list[llist]

                OPLOT, tim[list]-tim[0], bs[list], COLOR=200

                pitch = ASIN(SQRT(bratio<1))
 
                ; loop over l points

                FOR l = 0, count-1 DO BEGIN

                  ; index into lpoints
                  
                  ll = list[l]

                  ; looop over energies

                  FOR e = 0, (SIZE(dat))[1]-1 DO BEGIN

                    sinfit, pitch[ll], dat[e,*,ll], f

                    output[p,dlist[k]].data[e,ll] = f 

                  ENDFOR

                ENDFOR

              ENDIF

              IF ask THEN IF GET_KBRD(1) EQ 's' THEN ask = 0

            ENDIF

          ENDIF

        ENDIF

      ENDFOR

    ENDIF

  ENDFOR

  RETURN, output

END
