; for use with lsh_monitor
; 2/nov/01 -- removed corrected_lshell and dst keyword -- unused
;            

FUNCTION get_lshells, ephem, header, data, EXNAME=exname

  lshells = INTERPOL ( ephem.l, ephem.time, data.time )

  IF KEYWORD_SET(exname) THEN BEGIN

    ; get direction

    IF lshells[0] LT lshells[header.npoints-1] THEN sign=1 ELSE sign=-1

    nl = 10

    list = WHERE(ephem.time GE data[0].time AND ephem.time LE data[header.npoints-1].time, count)

    IF count EQ 0 THEN MESSAGE,'Error -- no valid times' 

    IF count LT nl THEN BEGIN
      llist = list
      nl = count
    ENDIF ELSE BEGIN
      llist = list[(INDGEN(nl)*(count-1))/(nl-1)]
    ENDELSE

    WINDOW, 2

    start_time = data[0].time-1000.

    PLOT, data.time - start_time, lshells, PSYM=4

    OPLOT, ephem.time - start_time, ephem.l

    lsh = FLTARR(nl)
    terminate = 0

    FOR k = 0, nl-1 DO BEGIN

      IF sign EQ -1 THEN kk = nl-1-k

      IF NOT terminate THEN BEGIN 

    ;    lsh[kk] = corrected_lshell(ephem[llist[kk]], DST=dst, EXNAME=exname)

        OPLOT, [ephem[llist[kk]].time-start_time], [lsh[kk]], PSYM=2
      
        IF lsh[kk] EQ 0 THEN terminate=1

      ENDIF

    ENDFOR

    lshells = clean_lshells( lsh, ephem[llist].time, data.time)

    ; check lshells monotonic

    mlist = WHERE( sign*(lshells[1:*]-lshells) LE 0, mcount)

    IF mcount NE 0 THEN BEGIN

      PRINT, 'Non-monotonic L'

      mlist = [0]
      l = lshells[0]
      FOR k=1,header.npoints-1 DO BEGIN
        IF sign*(lshells[k]-l) GT 0 THEN BEGIN
          mlist = [mlist,k]
          l = lshells[k]
        ENDIF
      ENDFOR

      lshells = lshells[mlist]

      data = data[mlist]

      header.npoints = N_ELEMENTS(mlist)

    ENDIF

    mlist = WHERE( sign*(lshells[1:*]-lshells) LE 0, mcount)

    IF mcount NE 0 THEN MESSAGE,'Problem'

  ENDIF 

  RETURN, lshells

END