FUNCTION get_parmod, xtime, DST=xdst, PDYN=xpdyn, BIMF=xbimf

  COMMON dst_block, dst
  COMMON pdyn_block, pdyn, delay
  COMMON bimf_block, bimf

  time = utc2tai(anytim2utc(xtime))

  parmod = [5.0, 0.0, 0.0, 0.0, 0, 0, 0, 0, 0, 0]

  IF KEYWORD_SET(xpdyn) AND N_ELEMENTS(pdyn) EQ 0 THEN BEGIN

    PRINT, 'RESTORING Pdyn'
    RESTORE, concat_dir(ies_get_dir('SAV',/POLAR),'swe_98.sav')
    pdyn = manipulate_wind(swe, /RAMP, DELAY=delay)

    ; convert from keV/cc to nPa

    pdyn.data = pdyn.data*0.16

  ENDIF

  IF KEYWORD_SET(xdst) AND N_ELEMENTS(dst) EQ 0 THEN BEGIN
    PRINT, 'RESTORING Dst'
    RESTORE, concat_dir(ies_get_dir('SAV',/POLAR),'dst_hourly.sav')
  ENDIF

  IF KEYWORD_SET(xbimf) AND N_ELEMENTS(bimf) EQ 0 THEN BEGIN
    PRINT, 'RESTORING Bimf'
    RESTORE, concat_dir(ies_get_dir('SAV',/POLAR),'mfi_98.sav')
    bimf = manipulate_mfi(mfi, DELAY=delay)
  ENDIF

  IF KEYWORD_SET(xpdyn) THEN BEGIN
    IF time LT pdyn[0].time OR time GT pdyn[N_ELEMENTS(pdyn)-1].time THEN $
      MESSAGE, 'Out of time range for PDYN' $
    ELSE parmod[0] = INTERPOL(pdyn.data,pdyn.time,time)
  ENDIF

  IF KEYWORD_SET(xdst) THEN BEGIN
    IF time LT dst[0].time OR time GT dst[N_ELEMENTS(dst)-1].time THEN $
      MESSAGE, 'Out of time range for DST' $
    ELSE parmod[1] = INTERPOL(dst.dst,dst.time,time)
  ENDIF

  IF KEYWORD_SET(xbimf) THEN BEGIN
    IF time LT bimf[0].time OR time GT bimf[N_ELEMENTS(bimf)-1].time THEN BEGIN
      MESSAGE, 'Out of time range for BIMF'
    ENDIF ELSE IF KEYWORD_SET(delay) THEN BEGIN
      IF time LT delay[0].time OR time GT delay[N_ELEMENTS(delay)-1].time THEN BEGIN
        MESSAGE, 'Out of time range for DELAY'
      ENDIF ELSE BEGIN
        parmod[2] = INTERPOL(bimf.data[0],bimf.time,time)
        parmod[3] = INTERPOL(bimf.data[1],bimf.time,time)
      ENDELSE
    ENDIF ELSE BEGIN
      parmod[2] = INTERPOL(bimf.data[0],bimf.time,time)
      parmod[3] = INTERPOL(bimf.data[1],bimf.time,time)
    ENDELSE
  ENDIF

  RETURN, parmod

END