FUNCTION interp, x, y, xx, ENDS=ends, IND=ind

  nx  = N_ELEMENTS(x)
  nxx = N_ELEMENTS(xx)

  IF nx LT 2 THEN MESSAGE, 'Insufficient data points'

  ; remove constant points at ends

  ip = 0
  fp = nx-1

  IF KEYWORD_SET(ends) THEN BEGIN
    WHILE ip LT nx-1 AND x[(ip+1) < (nx-1)] EQ x[ip] DO ip = ip+1  
    WHILE fp GT ip AND x[(fp-1)>0] EQ x[fp] DO fp = fp-1 
  ENDIF

  ; check monotonic abscissae

  IF x[ip] GT x[fp] THEN BEGIN

    list = WHERE(x[ip+1:fp] GE x[ip:fp-1], count)
    maxx = x[ip]
    minx = x[fp]

  ENDIF ELSE BEGIN

    list = WHERE(x[ip+1:fp] LE x[ip:fp-1], count)
    minx = x[ip]
    maxx = x[fp]

  ENDELSE

  IF count NE 0 THEN MESSAGE, 'X values not strictly monotonic'

  ; locate points closest to xx values required

  IF KEYWORD_SET(ind) THEN ind = 0>FIX(INTERPOL(ip+INDGEN(fp-ip+1),x,xx))<fp

  yy = INTERPOL(y[ip:fp],x[ip:fp],xx)

  ; only process those points in range

  list = WHERE(xx LT minx OR xx GT maxx, count)

  IF count GT 0 THEN yy[list] = !VALUES.F_NAN

  ; calculate interpolation

  RETURN, yy 

END