PRO lsh_match, t, u, list_t, list_u

  list_t  = 0
  list_u = 0
  kk = 0

  FOR k = 0, N_ELEMENTS(t)-1 DO BEGIN

    going = 1
    WHILE going NE 0 DO BEGIN

      IF kk LT N_ELEMENTS(u) THEN BEGIN
        IF t(k) GT u(kk) THEN kk = kk + 1 ELSE going = 0
      ENDIF ELSE going = 0

    ENDWHILE

    IF kk LT N_ELEMENTS(u) THEN BEGIN
      IF t(k) EQ u(kk) THEN BEGIN
        list_t = [list_t,k]
        list_u = [list_u,kk]
        ;IF o0(k) NE o1(kk) THEN PRINT, 'Orbits do not match'
      ENDIF
    ENDIF

  ENDFOR ; loop over t0

  IF N_ELEMENTS(list_t) GT 1 THEN BEGIN
    list_t = list_t(1:*)
    list_u = list_u(1:*)
  ENDIF ELSE MESSAGE, 'No times match'

  PRINT, 'Matches found = ',N_ELEMENTS(list_t)

END

PRO lsh_display, IMAGES=small_images, s0, s1, s2, s3, CUSPS=cusps, NEW=new, ODD=odd, EVEN=even

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0

  IF N_ELEMENTS(small_images) LE 1 OR KEYWORD_SET(new) THEN BEGIN

    ; try to match times

    IF N_ELEMENTS(s0) GT 0 THEN BEGIN

      tt0 = REFORM((s0.time(0,*)+s0.time((SIZE(s0.time))(1)-1,*))/2)
      list0 = INDGEN(N_ELEMENTS(tt0))
      t = tt0

    ENDIF

    IF N_ELEMENTS(s1) GT 0 THEN BEGIN

      tt1 = REFORM((s1.time(0,*)+s1.time((SIZE(s1.time))(1)-1,*))/2)

      lsh_match, t, tt1, list, list1

      list0 = list
      t = t(list)

    ENDIF

    IF N_ELEMENTS(s2) GT 0 THEN BEGIN

      tt2 = REFORM((s2.time(0,*)+s2.time((SIZE(s2.time))(1)-1,*))/2)

      lsh_match, t, tt2, list, list2

      list0 = list0(list)
      list1 = list1(list)
      t = t(list)

    ENDIF

    IF N_ELEMENTS(s3) GT 0 THEN BEGIN

      tt3 = REFORM((s3.time(0,*)+s3.time((SIZE(s3.time))(1)-1,*))/2)

      lsh_match, t, tt3, list, list3

      list0 = list0(list)
      list1 = list1(list)
      list2 = list2(list)
      t = t(list)

    ENDIF

    IF KEYWORD_SET(odd) THEN BEGIN

      list = WHERE (s0[list0].orbit EQ 1, count)

      IF count EQ 0 THEN RETURN

      list0 = list0[list]
      list1 = list1(list)
      list2 = list2(list)
      list3 = list3(list)
      t = t(list)

    ENDIF ELSE IF KEYWORD_SET(even) THEN BEGIN

      list = WHERE (s0[list0].orbit EQ 0, count)

      IF count EQ 0 THEN RETURN

      list0 = list0[list]
      list1 = list1(list)
      list2 = list2(list)
      list3 = list3(list)
      t = t(list)

    ENDIF

    IF N_ELEMENTS(s0) GT 0 THEN e0 = TRANSPOSE(s0[list0].data,[1,2,0])
    IF N_ELEMENTS(s1) GT 0 THEN e1 = TRANSPOSE(s1[list1].data,[1,2,0])
    IF N_ELEMENTS(s2) GT 0 THEN e2 = TRANSPOSE(s2[list2].data,[1,2,0])
    IF N_ELEMENTS(s3) GT 0 THEN e3 = TRANSPOSE(s3[list3].data,[1,2,0])

    ; concatenate data sets

    IF N_ELEMENTS(e0) GT 0 THEN small_images = e0
    IF N_ELEMENTS(e2) GT 0 THEN small_images = [[[TEMPORARY(small_images)]],[[e2]]]
    IF N_ELEMENTS(e1) GT 0 THEN small_images = [[[TEMPORARY(small_images)]],[[e1]]]
    IF N_ELEMENTS(e3) GT 0 THEN small_images = [[[TEMPORARY(small_images)]],[[e3]]]

    small_images = TRANSPOSE(TEMPORARY(small_images),[2,0,1])

    temp = REPLICATE({ltimes:s0[0].time,orbit:0,image:small_images(*,*,0)},N_ELEMENTS(t))

    temp.ltimes  = s0[list0].time
    temp.image   = TEMPORARY(small_images)
    temp.orbit   = s0[list0].orbit
    small_images = TEMPORARY(temp)

  ENDIF ; create small_images

  ; set up large image array

;  large_images = BYTARR ( 10*(SIZE(small_images))(1),10*(SIZE(small_images))(2),(SIZE(small_images))(3) )
; large_images = BYTARR ( 2*(SIZE(small_images))(1),(SIZE(small_images))(2),(SIZE(small_images))(3) )

  ; display times in images

;  SET_PLOT,'Z'
;  DEVICE, SET_RES=[(SIZE(large_images))(1),(SIZE(large_images))(2)]

;  FOR k = 0, nm-1 DO BEGIN

;    ERASE

;    TV, REBIN(small_images(*,*,k),(SIZE(large_images))(1),(SIZE(large_images))(2),/SAMPLE)

;    XYOUTS, 50, (SIZE(large_images))(2)-10, /DEVICE, ANYTIM2CAL(tims(k))

 ;   large_images(*,*,k) = TVRD()

;  ENDFOR ; end loop over images

  SET_PLOT, devname

  IF KEYWORD_SET(movie) THEN BEGIN

    ; set file name for output

    gif_root = concat_dir ( ies_get_dir('MV',/POLAR), 'mov_ies_hist_' )

    FOR f = 0, (SIZE(large_images))(3)-1 DO WRITE_GIF, gif_root + STRING(f,FORMAT='(I3.3)') + '.gif', large_images(*,*,f)

  ENDIF ELSE BEGIN

    ; get cusp data

    IF KEYWORD_SET(cusps) THEN BEGIN

      RESTORE, '/disk2/carter/plasma/cusps/cusps.sav'

    ENDIF

    ; get scale factor

    factor = (200/(SIZE(small_images.image))(1)) > 1

    n_images = N_ELEMENTS(small_images)
    list = INDGEN(n_images)

    IF KEYWORD_SET(even) THEN list = WHERE(small_images.orbit EQ 0, n_images)

    IF KEYWORD_SET(odd)  THEN list = WHERE(small_images.orbit EQ 1, n_images)

    ; display images

    XINTERANIMATE, SET=[factor*(SIZE(small_images.image))(1),(SIZE(small_images.image))(2),n_images]

    smin = ALOG(MIN(small_images[list].image)>1)
    smax = ALOG(MAX(small_images[list].image)>1)

    FOR f = 0, n_images-1 DO BEGIN

      image = ALOG(small_images(list[f]).image>1)

      IF smax-smin NE 0 THEN image = !d.n_colors*(image-smin)/(smax-smin)

      image = REBIN(image,factor*(SIZE(image))(1),(SIZE(image))(2),/SAMPLE)

      ; display times in images

      SET_PLOT,'Z'
      DEVICE, SET_RES=[(SIZE(image))(1),(SIZE(image))(2)]
      ERASE

      TV, image

      nltimes = N_ELEMENTS(small_images[0].ltimes) ; one more than L dimension
      XYOUTS, 25, 5, /DEVICE, ANYTIM2CAL((small_images[list[f]].ltimes[0]+small_images[list[f]].ltimes[nltimes-1])/2)
      XYOUTS, 0, 5, /DEVICE, STRTRIM(small_images[list[f]].orbit,2)

      ; get cusp info

      IF KEYWORD_SET(cusps) THEN BEGIN

        event_list = WHERE(events GE small_images[list[f]].ltimes[0] AND $
                     events LE small_images[list[f]].ltimes[nltimes-1], event_count)

        range_list = WHERE(ranges[0,*] GE small_images[list[f]].ltimes[0] AND $
                     ranges[1,*] LE small_images[list[f]].ltimes[nltimes-1], range_count)

        IF event_count NE 0 OR range_count NE 0 THEN BEGIN

          IF event_count GT 0 THEN BEGIN

            levents = INTERPOL( FINDGEN(nltimes),small_images[list[f]].ltimes,events(event_list))

            FOR l = 0, event_count-1 DO BEGIN

              TV, REPLICATE(255,10), 80, levents(l)

              XYOUTS, 90, levents(l), event_comments[event_list[l]], /DEVICE

            ENDFOR

          ENDIF

          IF range_count GT 0 THEN BEGIN

            lranges = INTERPOL( FINDGEN(nltimes),small_images[list[f]].ltimes,ranges[0,range_list])
            uranges = INTERPOL( FINDGEN(nltimes),small_images[list[f]].ltimes,ranges[1,range_list])

            FOR l = 0, range_count-1 DO BEGIN

              lmin = MIN([lranges[l],uranges[l]]) > 0
              lmax = MAX([lranges[l],uranges[l]]) < ((SIZE(image))(2)-1)

              TV, REPLICATE(255,1,lmax-lmin+1), 80, lmin

              XYOUTS, 90, (lmax+lmin)/2, range_comments[range_list[l]], /DEVICE

            ENDFOR

          ENDIF

        ENDIF

      ENDIF ELSE count = 0

      image = TVRD()

      SET_PLOT, devname

      XINTERANIMATE, IMAGE=image, FRAME=f

    ENDFOR

    XINTERANIMATE, 1, /TRACK, TITLE='IES and HIST energy vs L shell = 0-'+STRTRIM((SIZE(small_images))(2)/10,2)

  ENDELSE

END