; 19/oct/01 -- added temporary saving of structure array in case of crash
; 26/oct/01 changed map strcuture
; 2/nov/01 removed nmaglon keyword
;          added variable nlshells

; gets structure containing mlt and mlat and time for each orbit
; believe was previously an error for mlat
; map generates corrected lshell map

PRO lsh_ephem, xlsh, struct, T0=t0, T1=t1, MAP=map, SHOW=show, NLSHELLS=nLshells, QUIET=quiet

  ; come back out to top level

  ON_ERROR, 0 ; stay at error point

  ; set show

  IF NOT KEYWORD_SET(show) THEN show = 0

  ; process times

  IF KEYWORD_SET(t0) THEN BEGIN

    tai = utc2tai(anytim2utc (t0))

    list = WHERE(xlsh[0,*].time_start GT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits after start time'
      RETURN
    ENDIF

    start_orbit = list[0]

  ENDIF ELSE start_orbit = 0

  IF KEYWORD_SET(t1) THEN BEGIN

    tai = utc2tai(anytim2utc (t1))

    list = WHERE(xlsh[0,*].time_end LT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits before end time'
      RETURN
    ENDIF

    end_orbit = list[count-1]

  ENDIF ELSE end_orbit = (SIZE(xlsh))(2)-1

  ; set nparts

  nparts = (SIZE(xlsh))[1]

  IF KEYWORD_SET(show) THEN WINDOW, 0, XSIZE=768, YSIZE=768

  ; set up output structure

  IF KEYWORD_SET(map) THEN BEGIN
    struct=REPLICATE(lshell_struct(NLSHELLS=nlshells), nparts,end_orbit-start_orbit+1)
  ENDIF ELSE BEGIN
    struct=REPLICATE({EPHEM_STR_V3,time:0.0d0,mlt:0.0,mlat:0.0},nparts,end_orbit-start_orbit+1)
  ENDELSE

  ; loop through orbits

  FOR o = start_orbit, end_orbit DO BEGIN

    ; process each part of the orbit

    FOR p = 0, nparts-1 DO BEGIN

      ; get data for this part of the orbit

      PRINT, 'Orbit ',o,' Part ',p

      ephem = lsh_get_ephem([xlsh[p,o].time_start ,xlsh[p,o].time_end])

      IF KEYWORD_SET(map) THEN BEGIN

        struct[p,o-start_orbit] = map_lshells(ephem,xlsh[p,o].time_start,xlsh[p,o].time_end, SHOW=show, NLSHELLS=nlshells, QUIET=quiet)

        SAVE, struct, FILE='struct.sav'

      ENDIF ELSE BEGIN

        times = [xlsh[p,o].time_start,xlsh[p,o].time_end]
        struct[p,o-start_orbit].time = TOTAL(times)/2
        struct[p,o-start_orbit].mlt  = TOTAL(INTERPOL( ephem.edmlt, ephem.time, times))/2
        struct[p,o-start_orbit].mlat = TOTAL(INTERPOL( ephem.mlat , ephem.time, times))/2

      ENDELSE

      IF show EQ 1 THEN BEGIN

        ; display data
        ; NB if array has only one point still plot

        start_time = ephem[0].time
        ERASE
        PLOT, [ephem.time-start_time], ephem.l, psym=-2, COLOR=200
        IF NOT KEYWORD_SET(map) THEN BEGIN
          OPLOT, [ephem.time-start_time], ephem.edmlt,COLOR=250
        ENDIF ELSE BEGIN
          OPLOT, [struct[p,o-start_orbit].time-start_time], [struct[p,o-start_orbit].lphi0], PSYM=1
          OPLOT, [struct[p,o-start_orbit].time-start_time], [struct[p,o-start_orbit].lphi], PSYM=1, COLOR=100
          OPLOT, [struct[p,o-start_orbit].time-start_time], [struct[p,o-start_orbit].lsh], PSYM=4
        ENDELSE

        str = get_kbrd(1)
        IF str EQ 's' THEN show=0

      ENDIF ELSE IF show EQ 2 THEN BEGIN

;        ERASE

      ENDIF

    ENDFOR; loop over p

  ENDFOR; loop over o

END