; plots data summed over specified channels from multiple sources

; 16/01/02 added encapsulated, xsize, ysize, notitle keywords
; 17/01/02 added FIXED_CHARSIZE keyword
; 06/06/02 Added AE index, moved AP
; 03/04/03 Used ies_set_plot rather than lsh_device.
; 15/05/03 Set devname and added FOREGROUND keyword.
; 01/10/03 Added POLAR switch to ies set plot.

PRO lsh_epoch, orbit, IES0=ies0, IES1=ies1, IES2=ies2, IES3=ies3, $
               IPS0=ips0, IPS1=ips1, IPS2=ips2, IPS3=ips3, $
               HISTE0=histe0, HISTE1=histe1, HISTE2=histe2, HISTE3=histe3, $
               HISTP0=histp0, HISTP1=histp1, HISTP2=histp2, HISTP3=histp3, $
               EIES0=eies0, EIES1=eies1, EIPS0= EIPS0, EIPS1=eips1, $
               EHISTE0=ehiste0, EHISTE1=ehiste1,EHISTP0=ehistp0, EHISTP1=ehistp1, $
               DST=dst, TMP=tmp, AP=ap, AE=ae, LUT=lut, LCT=lct, $
               SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
               LSHELLS = lshells, t0=t0, t1=t1, WHITE=white, FOREGROUND=foreground, $
               WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps, DIV=div, $
               LANDSCAPE=landscape, PORTRAIT=portrait, LINEPLOT=lineplot, TITLE = plot_title, $
               OVERLAY=overlay, DRANGE=drange, REALTIME=realtime, $
               RANGE_IES=range_ies, RANGE_IPS=range_ips, RANGE_HISTE=range_histe, RANGE_HISTP=range_histp, $
               CHARSIZE=charsize, XMARGIN=xmargin, YMARGIN=ymargin, DERIV=deriv, MAP=map, $
               NPLOTS=nplots, CTITLE=ctitle,$
               ENERGY_FLUX=energy_flux, ENERGY_DENSITY=energy_density, $
               NUMBER_DENSITY=number_density, PEAK=peak, AVERAGE=average, $
               ENCAPSULATED=encapsulated, XSIZE=xsize, YSIZE=ysize, NOTITLE=notitle, FIXED_CHARSIZE=fixed_charsize

  ; come back out to top level

  ON_ERROR, 0

  ; set up device

  devname = !D.NAME

  IF NOT KEYWORD_SET(xmargin) THEN xmargin = [7,12]
  IF NOT KEYWORD_SET(ymargin) THEN ymargin = [0,1]

  IF KEYWORD_SET(lineplot) THEN xmargin = [10,12]

  ; set display range defaults

  IF KEYWORD_SET(lineplot) THEN BEGIN
    IF NOT KEYWORD_SET(range_histe) THEN range_histe = [1e2,1e6]
    IF NOT KEYWORD_SET(range_ies) THEN range_ies = [1e6,8e7]
    IF NOT KEYWORD_SET(range_histp) THEN range_histp = [4e1,1e3]
    IF NOT KEYWORD_SET(range_ips) THEN range_ips = [1e7,4e8]
  ENDIF ELSE BEGIN
    IF NOT KEYWORD_SET(range_histe) THEN range_histe = [1e2,1e6]
    IF NOT KEYWORD_SET(range_ies) THEN range_ies = [1e3,8e7]
    IF NOT KEYWORD_SET(range_histp) THEN range_histp = [4e1,4e4]
    IF NOT KEYWORD_SET(range_ips) THEN range_ips = [2e3,2e7]
  ENDELSE

  ; get time range

  lsh_get_time_range, ies0, time_start, time_end
  lsh_get_time_range, ies1, time_start, time_end
  lsh_get_time_range, ies2, time_start, time_end
  lsh_get_time_range, ies3, time_start, time_end
  lsh_get_time_range, ips0, time_start, time_end
  lsh_get_time_range, ips1, time_start, time_end
  lsh_get_time_range, ips2, time_start, time_end
  lsh_get_time_range, ips3, time_start, time_end
  lsh_get_time_range, histe0, time_start, time_end
  lsh_get_time_range, histe1, time_start, time_end
  lsh_get_time_range, histe2, time_start, time_end
  lsh_get_time_range, histe3, time_start, time_end
  lsh_get_time_range, histp0, time_start, time_end
  lsh_get_time_range, histp1, time_start, time_end
  lsh_get_time_range, histp2, time_start, time_end
  lsh_get_time_range, histp3, time_start, time_end
  lsh_get_time_range, tmp, time_start, time_end
  lsh_get_time_range, lut, time_start, time_end
;  lsh_get_time_range, lct, time_start, time_end
  lsh_get_time_range, dst, time_start, time_end
  lsh_get_time_range, ap, time_start, time_end
  lsh_get_time_range, ae, time_start, time_end
  lsh_get_time_range, swe, time_start, time_end

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  IF N_ELEMENTS(orbit) EQ 0 THEN orbit = 0

  title = 'Lshell versus time plot'+([' (Incoming North)',' (Incoming South)',' (Outgoing South)',' (Outgoing North)'])[orbit]

  title = title[0]

  IF N_ELEMENTS(histe0) NE 0 THEN title = [title,'HISTe']
  IF N_ELEMENTS(histe1) NE 0 THEN title = [title,'HISTe1']
  IF N_ELEMENTS(histe2) NE 0 THEN title = [title,'HISTe2']
  IF N_ELEMENTS(histe3) NE 0 THEN title = [title,'HISTe3']
  IF N_ELEMENTS(ies0)   NE 0 THEN title = [title,'IES']
  IF N_ELEMENTS(ies1)   NE 0 THEN title = [title,'IES1']
  IF N_ELEMENTS(ies2)   NE 0 THEN title = [title,'IES2']
  IF N_ELEMENTS(ies3)   NE 0 THEN title = [title,'IES3']
  IF N_ELEMENTS(histp0) NE 0 THEN title = [title,'HISTp']
  IF N_ELEMENTS(histp1) NE 0 THEN title = [title,'HISTp1']
  IF N_ELEMENTS(histp2) NE 0 THEN title = [title,'HISTp2']
  IF N_ELEMENTS(histp3) NE 0 THEN title = [title,'HISTp3']
  IF N_ELEMENTS(ips0)   NE 0 THEN title = [title,'IPS']
  IF N_ELEMENTS(ips1)   NE 0 THEN title = [title,'IPS1']
  IF N_ELEMENTS(ips2)   NE 0 THEN title = [title,'IPS2']
  IF N_ELEMENTS(ips3)   NE 0 THEN title = [title,'IPS3']

  IF NOT KEYWORD_SET(plot_title) THEN plot_title = title

  IF NOT KEYWORD_SET(nplots) THEN nplots = N_ELEMENTS(title)-1

  IF N_ELEMENTS(tmp)    NE 0 THEN nplots=nplots+1
  IF N_ELEMENTS(lut)    NE 0 THEN nplots=nplots+1
  IF N_ELEMENTS(dst)    NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF N_ELEMENTS(ap)     NE 0 THEN nplots=nplots+1
  IF N_ELEMENTS(ae)     NE 0 THEN nplots=nplots+1
  IF N_ELEMENTS(lct)    NE 0 THEN nplots=nplots+2
  IF N_ELEMENTS(swe)    NE 0 THEN nplots=nplots+1

  ; test output device

  IF ies_set_plot( 0, devname, unit, file, /POLAR, NPLOTS=nplots, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
    BWPS=bwps, GIF=gif, LANDSCAPE=landscape, PORTRAIT=portrait, ENCAPSULATED=encapsulated, $
    XSIZE=xsize, YSIZE=ysize, CHARSIZE=charsize, FOREGROUND=foreground) THEN MESSAGE, 'ERROR IN PLOT SET UP'

  ; plot data

  pos = 0.95
  size = 0.9/nplots

  FOR k = 1, N_ELEMENTS(title)-1 DO BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    CASE title[k] OF
      'HISTe'  : BEGIN
                   chans = lsh_get_energies(/HISTE, e0=ehiste0, e1=ehiste1)
                   e0 = ehiste0
                   e1 = ehiste1
                   time = histe0[orbit,*].time
                   data = histe0[orbit,*].data(e0:e1,*)
                   range = range_histe
                   mass = 511.
                 END
      'HISTe1' : BEGIN
                   chans = lsh_get_energies(/HISTE, e0=ehiste0, e1=ehiste1)
                   e0 = ehiste0
                   e1 = ehiste1
                   time = histe1[orbit,*].time
                   data = histe1[orbit,*].data(e0:e1,*)
                   range = range_histe
                   mass = 511.
                 END
      'HISTe2' : BEGIN
                   chans = lsh_get_energies(/HISTE, e0=ehiste0, e1=ehiste1)
                   e0 = ehiste0
                   e1 = ehiste1
                   time = histe2[orbit,*].time
                   data = histe2[orbit,*].data(e0:e1,*)
                   range = range_histe
                   mass = 511.
                 END
      'HISTe3' : BEGIN
                   chans = lsh_get_energies(/HISTE, e0=ehiste0, e1=ehiste1)
                   e0 = ehiste0
                   e1 = ehiste1
                   time = histe3[orbit,*].time
                   data = histe3[orbit,*].data(e0:e1,*)
                   range = range_histe
                   mass = 511.
                 END
      'IES'    : BEGIN
                   chans = lsh_get_energies(/IES, e0=eies0, e1=eies1)
                   e0 = eies0
                   e1 = eies1
                   time = ies0[orbit,*].time
                   data = ies0[orbit,*].data(e0:e1,*)
                   range = range_ies
                   mass = 511.
                 END
      'IES1'   : BEGIN
                   chans = lsh_get_energies(/IES, e0=eies0, e1=eies1)
                   e0 = eies0
                   e1 = eies1
                   time = ies1[orbit,*].time
                   data = ies1[orbit,*].data(e0:e1,*)
                   range = range_ies
                   mass = 511.
                 END
      'IES2'   : BEGIN
                   chans = lsh_get_energies(/IES, e0=eies0, e1=eies1)
                   e0 = eies0
                   e1 = eies1
                   time = ies2[orbit,*].time
                   data = ies2[orbit,*].data(e0:e1,*)
                   range = range_ies
                   mass = 511.
                 END
      'IES3'   : BEGIN
                   chans = lsh_get_energies(/IES, e0=eies0, e1=eies1)
                   e0 = eies0
                   e1 = eies1
                   time = ies3[orbit,*].time
                   data = ies3[orbit,*].data(e0:e1,*)
                   range = range_ies
                   mass = 511.
                 END
      'HISTp'  : BEGIN
                   chans = lsh_get_energies(/HISTP, e0=ehistp0, e1=ehistp1)
                   e0 = ehistp0
                   e1 = ehistp1
                   time = histp0[orbit,*].time
                   data = histp0[orbit,*].data(e0:e1,*)
                   range = range_histp
                   mass = 938000.
                 END
      'HISTp1' : BEGIN
                   chans = lsh_get_energies(/HISTP, e0=ehistp0, e1=ehistp1)
                   e0 = ehistp0
                   e1 = ehistp1
                   time = histp1[orbit,*].time
                   data = histp1[orbit,*].data(e0:e1,*)
                   range = range_histp
                   mass = 938000.
                 END
      'HISTp2' : BEGIN
                   chans = lsh_get_energies(/HISTP, e0=ehistp0, e1=ehistp1)
                   e0 = ehistp0
                   e1 = ehistp1
                   time = histp2[orbit,*].time
                   data = histp2[orbit,*].data(e0:e1,*)
                   range = range_histp
                   mass = 938000.
                 END
      'HISTp3' : BEGIN
                   chans = lsh_get_energies(/HISTP, e0=ehistp0, e1=ehistp1)
                   e0 = ehistp0
                   e1 = ehistp1
                   time = histp3[orbit,*].time
                   data = histp3[orbit,*].data(e0:e1,*)
                   range = range_histp
                   mass = 938000.
                 END
      'IPS'    : BEGIN
                   chans = lsh_get_energies(/IPS, e0=eips0, e1=eips1)
                   e0 = eips0
                   e1 = eips1
                   time = ips0[orbit,*].time
                   data = ips0[orbit,*].data(e0:e1,*)
                   range = range_ips
                   mass = 938000.
                 END
      'IPS1'   : BEGIN
                   chans = lsh_get_energies(/IPS, e0=eips0, e1=eips1)
                   e0 = eips0
                   e1 = eips1
                   time = ips1[orbit,*].time
                   data = ips1[orbit,*].data(e0:e1,*)
                   range = range_ips
                   mass = 938000.
                 END
      'IPS2'   : BEGIN
                   chans = lsh_get_energies(/IPS, e0=eips0, e1=eips1)
                   e0 = eips0
                   e1 = eips1
                   time = ips2[orbit,*].time
                   data = ips2[orbit,*].data(e0:e1,*)
                   range = range_ips
                   mass = 938000.
                 END
      'IPS3'   : BEGIN
                   chans = lsh_get_energies(/IPS, e0=eips0, e1=eips1)
                   e0 = eips0
                   e1 = eips1
                   time = ips3[orbit,*].time
                   data = ips3[orbit,*].data(e0:e1,*)
                   range = range_ips
                   mass = 938000.
                 END
      ELSE :
    ENDCASE

    ; get mean channel energies and sizes

    echans = TOTAL(chans,1)/2
    esizes = REFORM(chans[1,*]-chans[0,*])

    ; select channel energies and sizes

    echans = echans[e0:e1]
    esizes = esizes[e0:e1]

    IF KEYWORD_SET(energy_flux) THEN BEGIN
      ctitle = 'keV/cm2/sr/s'
      ch = echans
      data = data*(ch#REPLICATE(1,N_ELEMENTS(data)/N_ELEMENTS(ch)))
    ENDIF ELSE IF KEYWORD_SET(energy_density) THEN BEGIN
      ctitle = 'keV/cm3'
      ch = 4*!PI*echans/SQRT(2*echans/mass)/3.e10
      data = data*(ch#REPLICATE(1,N_ELEMENTS(data)/N_ELEMENTS(ch)))
    ENDIF ELSE IF KEYWORD_SET(number_density) THEN BEGIN
      ctitle = 'cts/cm3'
      ch = 4*!PI/SQRT(2*echans/mass)/3.e10
      data = data*(ch#REPLICATE(1,N_ELEMENTS(data)/N_ELEMENTS(ch)))
    ENDIF

    data = TOTAL(data,1)

    lsh_plot, time, data, time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(k NE nplots), $
              RANGE=range, TITLE=plot_title[k], LINEPLOT=lineplot, DIV=div, /LOG, WHITE=white, $
              XMARGIN=xmargin, YMARGIN=ymargin, REALTIME=realtime, MAP=map, CTITLE=ctitle, $
              PEAK=peak, FIXED_CHARSIZE=fixed_charsize

    ; dst

    IF KEYWORD_SET(overlay) THEN BEGIN

      lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, DST=dst, AE=ae, $
        REALTIME=realtime, TIMES=time, $
        SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
        DERIV=deriv, OVERLAY=overlay, DRANGE=drange, AVERAGE=average, /NO_XAXIS

   ENDIF

   ENDFOR

  ; mlt

  IF N_ELEMENTS(lct) GT 0 THEN BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, 0, 24, xmargin, ymargin, XTITLE='Time', YTITLE='MLT', NO_XAXIS=(k NE nplots), /NO_ERASE

    ; plot mlt

    OPLOT, lct[orbit,*].time-time_start, (lct[orbit,*].mlt+48) MOD 24, PSYM=3

    ; plot noon line

    PLOTS, [!X.WINDOW(0), !X.WINDOW(1)], $
           [(!Y.WINDOW(0)+!Y.WINDOW(1))/2, (!Y.WINDOW(0)+!Y.WINDOW(1))/2], /NORMAL

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

    k = k+1

;  ENDIF

  ; mlat

;  IF 0 THEN BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, -90, 90, xmargin, ymargin, XTITLE='Time', YTITLE='MLAT', NO_XAXIS=(k NE nplots), /NO_ERASE

    ; plot mlt

    OPLOT, lct[orbit,*].time-time_start, lct[orbit,*].mlat, PSYM=3

    ; plot magnetic equator line

    PLOTS, [!X.WINDOW(0), !X.WINDOW(1)], $
           [(!Y.WINDOW(0)+!Y.WINDOW(1))/2, (!Y.WINDOW(0)+!Y.WINDOW(1))/2], /NORMAL

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

    k = k+1

  ENDIF

  ; dst

  IF NOT KEYWORD_SET(overlay) THEN BEGIN

    lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, AP=ap, AE=ae, DST=dst, $
      REALTIME=realtime, TIMES=time, $
      SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
      DERIV=deriv, OVERLAY=overlay, DRANGE=drange, AVERAGE=average

  ENDIF

  IF NOT KEYWORD_SET(notitle) THEN BEGIN

    XYOUTS, 0.5, 0.96, plot_title[0], $
          ALIGNMENT=0.5, CHARSIZE=!P.CHARSIZE, /NORMAL

  ENDIF

  ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, BWPS=bwps, GIF=gif, PNG=png

END