; plots IES and HISTE electron data
; multiple energy panels selected from both IES and HISTe

; 16/01/02 added encapsulated, xsize, ysize, notitle keywords
; 17/01/02 added FIXED_CHARSIZE keyworc
; 03/04/03 Used ies_set_plot rather than lsh_device.

PRO lsh_epoch_el, orbit, ies, histe, LSHELLS = lshells, t0=t0, t1=t1, $
               WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps, $
               CHARSIZE=charsize, XMARGIN=xmargin, YMARGIN=ymargin, $
               LANDSCAPE=landscape, PORTRAIT=portrait, LINEPLOT=lineplot, $
               IES_ENERGIES=ies_energies, HISTE_ENERGIES=histe_energies, $
               IES_RANGE=ies_range, HISTE_RANGE=histe_range, REALTIME=realtime, $
               NOLOG=nolog, ENERGY=energy, TITLE=title, PEAK=peak, DST=dst, DRANGE=drange, $
               WHITE=white, AVERAGE=average, $
               ENCAPSULATED=encapsulated, XSIZE=xsize, YSIZE=ysize, NOTITLE=notitle, FIXED_CHARSIZE=fixed_charsize


  ; come back out to top level

  ON_ERROR, 0

  IF NOT KEYWORD_SET(xmargin) THEN xmargin = [7,12]
  IF NOT KEYWORD_SET(ymargin) THEN ymargin = [0,1]

  IF NOT KEYWORD_SET(nolog) THEN log = 1 ELSE log = 0

  ; get time range

  lsh_get_time_range, ies, time_start, time_end
  lsh_get_time_range, histe, time_start, time_end

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  ; plot data

  IF N_ELEMENTS(ies_energies) EQ 0 THEN ies_energies = [2,5,8]

  IF N_ELEMENTS(histe_energies) EQ 0 THEN histe_energies = [6,11]

  nplots = N_ELEMENTS(ies_energies)+N_ELEMENTS(histe_energies)

  IF KEYWORD_SET(dst) THEN nplots = nplots+1

  ; test output device

  ies_set_plot, 0, devname, unit, file, NPLOTS=nplots, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, $
    BWPS=bwps, LANDSCAPE=landscape, PORTRAIT=portrait, ENCAPSULATED=encapsulated, $
    XSIZE=xsize, YSIZE=ysize, CHARSIZE=charsize

  pos = 0.95
  size = 0.9/nplots

  ies_chans = lsh_get_energies(/IES )

  histe_chans = lsh_get_energies(/HISTE )

  ies_ens = TOTAL(ies_chans,1)/2.
  ies_esizes = ies_chans[1,*]-ies_chans[0,*]
  ies_dims = STRTRIM(STRING(ies_ens,FORMAT='(I)'),2) + ' keV'

  histe_ens = TOTAL(histe_chans,1)/2.
  histe_esizes = histe_chans[1,*]-histe_chans[0,*]
  histe_dims = STRTRIM(STRING(histe_ens,FORMAT='(I)'),2) + ' keV'

  IF KEYWORD_SET(energy) THEN rf = 2.0 ELSE rf = 1

  IF NOT KEYWORD_SET(ies_range) THEN ies_range = [1e2,4e6]*rf

  FOR k = 0, N_ELEMENTS(ies_energies)-1 DO BEGIN

    nplots = nplots-1

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = ies_ens[k] ELSE en = 1

    lsh_plot, ies[orbit,*].time, en*REFORM(ies[orbit,*].data(ies_energies[k]:ies_energies[k],*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=nplots NE 0, $
         RANGE=ies_range, TITLE=ies_dims[ies_energies[k] MOD N_ELEMENTS(ies_dims)], LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak, WHITE=white, FIXED_CHARSIZE=fixed_charsize

  ENDFOR

  IF NOT KEYWORD_SET(histe_range) THEN histe_range = [1e0,1e5]*rf

  FOR k = 0, N_ELEMENTS(histe_energies)-1 DO BEGIN

    nplots = nplots-1

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = histe_ens[k] ELSE en = 1

    lsh_plot, histe[orbit,*].time, en*REFORM(histe[orbit,*].data(histe_energies[k]:histe_energies[k],*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=nplots NE 0, $
         RANGE=histe_range, TITLE=histe_dims[histe_energies[k] MOD N_ELEMENTS(histe_dims)], LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak, WHITE=white, FIXED_CHARSIZE=fixed_charsize

  ENDFOR

  ; dst

  lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, DST=dst, DRANGE=drange, AVERAGE=average, REALTIME=realtime, TIMES=ies[orbit,*].time

  IF NOT KEYWORD_SET(notitle) THEN BEGIN

    IF NOT KEYWORD_SET(title) THEN title = 'Lshell plot for Electron data'+([' (Incoming North)',' (Incoming South)',' (Outgoing South)',' (Outgoing North)'])[orbit]

    XYOUTS, 0.5, 0.96, title, $
            ALIGNMENT=0.5, CHARSIZE=!P.CHARSIZE, /NORMAL

  END

  ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, BWPS=bwps, GIF=gif, PNG=png

END