; plots mulitple energies from single source

; 16/01/02 added XLCFL, added encapsulated, xsize, ysize, notitle keywords
; 17/01/02 added FIXED_CHARSIZE, WHITE keywords
; 03/04/03 Used ies_set_plot rather than lsh_device.
; 01/10/03 Added POLAR switch to ies set plot.

PRO lsh_epoch_energies, orbit, struct, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, CRRES=crres, $
               DST=dst, TMP=tmp, ENERGIES=energies, WHITE=white, $
               LSHELLS = lshells, t0=t0, t1=t1, RANGE=range, $
               XWINDOWS=xwindows, POSTSCRIPT=postscript, GIF=gif, PNG=png, BWPS=bwps, $
               LANDSCAPE=landscape, PORTRAIT=portrait, DIV=div, DRANGE=drange, $
               CHARSIZE=charsize, TITLE=title, XMARGIN=xmargin, YMARGIN=ymargin, $
               DERIV=deriv, BTITLE=btitle, CTITLE=ctitle, $
               SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
               OVERLAY=overlay, REALTIME=realtime, MAP=map, NOLOG=nolog, $
               LCFL=lcfl, XLCFL=xlcfl, NPLOTS=nplots, PEAK=peak, AVERAGE=average, $
               ENCAPSULATED=encapsulated, XSIZE=xsize, YSIZE=ysize, NOTITLE=notitle, FIXED_CHARSIZE=fixed_charsize

  ; come back out to top level

  ON_ERROR, 0

  IF NOT KEYWORD_SET(xmargin) THEN xmargin = [7,12]
  IF NOT KEYWORD_SET(ymargin) THEN ymargin = [0,1]

  IF KEYWORD_SET(nolog) THEN log = 0 ELSE log = 1

  ; set display range defaults

  IF NOT KEYWORD_SET(range) THEN BEGIN
    IF KEYWORD_SET(histe) THEN range = [1e0,4e5] $
    ELSE IF KEYWORD_SET(ies) THEN range = [5e3,2e7] $
    ELSE IF KEYWORD_SET(ips) THEN range = [1e0,4e4] $
    ELSE IF KEYWORD_SET(histp) THEN range = [5e3,2e7] $
    ELSE range = [1e0,1e6]
  ENDIF

  IF NOT KEYWORD_SET(btitle) THEN btitle=''

  IF N_ELEMENTS(energies) EQ 0 THEN energies = INDGEN((SIZE(struct.data))(1))

  chans = lsh_get_energies(IES=ies, IPS=ips, HISTE=histe, HISTP=histp, CRRES=crres )

  IF N_ELEMENTS(chans) GT 1 THEN BEGIN

    dims = STRTRIM(STRING(TOTAL(chans,1)/2.,FORMAT='(I)'),2) + ' keV'
    esizes = chans[1,*]-chans[0,*]

  ENDIF ELSE BEGIN

    dims = 'ch.'+STRTRIM(INDGEN(MAX(energies)+1),2)
    esizes = REPLICATE(1,N_ELEMENTS(dims))

  ENDELSE

  ; get time range

  lsh_get_time_range, struct, time_start, time_end
  lsh_get_time_range, tmp, time_start, time_end

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  IF NOT KEYWORD_SET(nplots) THEN nplots = N_ELEMENTS(energies)

  IF N_ELEMENTS(tmp)   NE 0 THEN nplots=nplots+1
  IF N_ELEMENTS(dst)   NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF N_ELEMENTS(wind)  NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF N_ELEMENTS(lcfl)  NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF N_ELEMENTS(xlcfl) NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1

  ; test output device

  IF ies_set_plot( 0, devname, unit, file, /POLAR, NPLOTS=nplots, WINDOWS=windows, POSTSCRIPT=postscript, GIF=gif, PNG=png, $
    BWPS=bwps, LANDSCAPE=landscape, PORTRAIT=portrait, ENCAPSULATED=encapsulated, $
    XSIZE=xsize, YSIZE=ysize, CHARSIZE=charsize) THEN MESSAGE, 'ERROR IN PLOT SET UP'

  IF NOT KEYWORD_SET(title) THEN BEGIN
    titles = [' (Incoming North)',' (Incoming South)',' (Outgoing South)',' (Outgoing North)']
    title = titles[orbit[0]]
    FOR k = 1 , N_ELEMENTS(orbit)-1 DO title = title + '/' + titles[orbit[k]]
    title = anytim2cal(time_start,/DATE)+' to '+anytim2cal(time_end,/DATE)+ ' ' + title
  ENDIF

  IF KEYWORD_SET(notitle) THEN title = ''

  ; set up page

  lsh_plot_setup, title, nplots, pos, size

  IF KEYWORD_SET(lcfl)  THEN tlcfl  = lcfl[orbit,*]
  IF KEYWORD_SET(xlcfl) THEN txlcfl = xlcfl[orbit,*]

  FOR k = 0, N_ELEMENTS(energies)-1 DO BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    dat = REFORM(struct[orbit,*].data[energies[k],*])
    IF (SIZE(dat))[0] EQ 2 THEN dat = REFORM(dat,(SIZE(dat))[1],1,(SIZE(dat))[2])

    IF KEYWORD_SET(div) THEN dat = dat/esizes[k]

    IF KEYWORD_SET(histe) THEN $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE='HISTe ['+dims[energies[k]]+']', LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize $
    ELSE IF KEYWORD_SET(ies) THEN $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE='IES ['+dims[energies[k]]+']', LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize $
    ELSE IF KEYWORD_SET(histp) THEN $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE='HISTp ['+dims[energies[k]]+']', LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize $
    ELSE IF KEYWORD_SET(ips) THEN $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE='IPS ['+dims[energies[k]]+']', LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize $
    ELSE IF KEYWORD_SET(crres) THEN $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE='CRRES ['+dims[energies[k]]+']', LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize $
    ELSE $
      lsh_plot, struct[orbit,*].time, dat, DIV=div, $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, NO_XAXIS=(1+k NE nplots), $
         RANGE=range, TITLE=btitle, LINEPLOT=lineplot, LOG=log, $
         XMARGIN=xmargin, YMARGIN=ymargin, CTITLE=ctitle, REALTIME=realtime, MAP=map, $
         LCFL=tlcfl, XLCFL=txlcfl, WHITE=white, PEAK=peak, FIXED_CHARSIZE=fixed_charsize

    IF KEYWORD_SET(overlay) THEN BEGIN

      lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, DST=dst, $
        REALTIME=realtime, TIMES=struct[orbit,*].time, $
        SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
        DERIV=deriv, OVERLAY=overlay, DRANGE=drange, TMP=tmp, $
        LCFL=tlcfl, XLCFL=txlcfl, LSHELLS=lshells, AVERAGE=average, /NO_XAXIS

    ENDIF

  ENDFOR

  IF NOT KEYWORD_SET(overlay) THEN BEGIN

    lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, DST=dst, $
      REALTIME=realtime, TIMES=struct[orbit,*].time, $
      SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
      DERIV=deriv, OVERLAY=overlay, DRANGE=drange, TMP=tmp, $
      LCFL=tlcfl, XLCFL=txlcfl,  LSHELLS=lshells, AVERAGE=average

  ENDIF

  ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, BWPS=bwps, GIF=gif, PNG=png

END