; 03/04/03 Used ies_set_plot rather than lsh_device.
; 01/10/03 Added POLAR switch to ies set plot.

PRO lsh_epoch_pr, orbit, ips, histp, LSHELLS = lshells, t0=t0, t1=t1, RANGES=ranges, $
               WINDOWS=windows, POSTSCRIPT=postscript, GIF=gif, BWPS=bwps, $
               LANDSCAPE=landscape, PORTRAIT=portrait, LINEPLOT=lineplot, ENERGY=energy, PEAK=peak

  ; come back out to top level

  ON_ERROR, 0

  xmargin = [7,12]
  ymargin = [0,1]

  ; get time range

  lsh_get_time_range, ips, time_start, time_end
  lsh_get_time_range, histp, time_start, time_end

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  ; test output device

  IF ies_set_plot( 0, devname, unit, file, /POLAR, NPLOTS=nplots, WINDOWS=windows, POSTSCRIPT=postscript, GIF=gif, BWPS=bwps, $
     LANDSCAPE=landscape, PORTRAIT=portrait, CHARSIZE=charsize) THEN MESSAGE, 'ERROR IN PLOT SET UP'

  ; plot data

  nplots = 6
  pos = 0.95
  size = 0.9/nplots

  IF KEYWORD_SET(energy) THEN rf = 2.0 ELSE rf = 1

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (21+28)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(1:1,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='21:28 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (38+50)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(3:3,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='38:50 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (66+88)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(5:5,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='66:88 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (120+160)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(7:7,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='120:160 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (220+300)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(9:9,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='220:300 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(energy) THEN en = (420+570)/2. ELSE en = 1

    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(11:11,*)), $
         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
         RANGE=[1e2,4e6]*rf, TITLE='420:570 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin, PEAK=peak

;    pos = pos - size
;
;    !P.REGION = [0,pos,1,pos+size]
;
;    IF KEYWORD_SET(energy) THEN en = (1090+1500)/2. ELSE en = 1

;    lsh_plot, ips[orbit,*].time, en*REFORM(ips[orbit,*].data(14:14,*)), $
;         time_start, time_end, LSHELLS=lshells, /NO_ERASE, /NO_XAXIS, $
;         RANGE=[1e2,4e6]*rf, TITLE='1090:1500 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin
;
;    pos = pos - size
;
;    !P.REGION = [0,pos,1,pos+size]
;
;    IF KEYWORD_SET(energy) THEN en = (4650+5790)/2. ELSE en = 1

;    lsh_plot, histp[orbit,*].time, en*REFORM(histp[orbit,*].data(3:3,*)),$
;         time_start, time_end, LSHELLS=lshells, /NO_ERASE, $
;         RANGE=[1e2,4e6]*rf, TITLE='4650:5790 keV', /LOG, XMARGIN=xmargin, YMARGIN=ymargin

  XYOUTS, 0.5, 0.96, 'Lshell plot for Proton data'+([' (Incoming North)',' (Incoming South)',' (Outgoing South)',' (Outgoing North)'])[orbit], $
          ALIGNMENT=0.5, CHARSIZE=!P.CHARSIZE, /NORMAL

  IF KEYWORD_SET(postscript) THEN BEGIN
    DEVICE, /CLOSE
    SET_PLOT, devname
  ENDIF

END