FUNCTION lsh_get_energies, INST=inst, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, CRRES=crres, E0=e0, E1=e1

  IF N_ELEMENTS(inst) EQ 0 THEN inst=''

  ; set up energy channels for instrument

  IF KEYWORD_SET(ies) OR STRPOS(inst,'IES') GE 0 THEN BEGIN

    IF STRPOS(inst,'IES') LT 0 THEN inst = 'IES'

    ch = [ [ 18.5000, 30.5000], $
             [ 30.5000, 42.5000], $
             [ 42.5000, 58.5000], $
             [ 58.5000, 80.5000], $
             [ 80.5000, 110.500], $
             [ 110.500, 152.500], $
             [ 152.500, 212.500], $
             [ 212.500, 294.500], $
             [ 294.500, 406.500], $
             [ 406.500, 426.500]]

    IF N_ELEMENTS(e0) EQ 0 THEN e0=1
    IF N_ELEMENTS(e1) EQ 0 THEN e1=9

  ENDIF ELSE IF KEYWORD_SET(ips)  OR STRPOS(inst,'IPS') GE 0 THEN BEGIN

    IF STRPOS(inst,'IPS') LT 0 THEN inst = 'IPS'

    ch = [ [ 16.8000, 21.2000], $
             [ 21.2000, 27.9000], $
             [ 27.9000, 37.5000], $
             [ 37.5000, 49.6000], $
             [ 49.6000, 65.9000], $
             [ 65.9000, 87.7000], $
             [ 87.7000, 118.000], $
             [ 118.000, 161.000], $
             [ 161.000, 221.000], $
             [ 221.000, 303.000], $
             [ 303.000, 417.000], $
             [ 417.000, 574.000], $
             [ 574.000, 791.000], $
             [ 791.000, 1091.00], $
             [ 1091.00, 1505.00], $
             [ 1505.00, 2000.00], $
             [ 0.00000, 2000.00]]

    IF N_ELEMENTS(e0) EQ 0 THEN e0=1
    IF N_ELEMENTS(e1) EQ 0 THEN e1=15

  ENDIF ELSE IF KEYWORD_SET(histe)  OR STRPOS(inst,'HISTe') GE 0 THEN BEGIN

    IF STRPOS(inst,'HISTe') LT 0 THEN inst = 'HISTe'

    ch = [ [ 100.000, 200.000], $
               [ 300.000, 400.000], $
               [ 656.734, 700.186], $
               [ 700.186, 743.639], $
               [ 743.639, 980.043], $
               [ 980.043, 1158.26], $
               [ 1158.26, 1421.74], $
               [ 1421.74, 1698.26], $
               [ 1698.26, 2101.74], $
               [ 2101.74, 2778.26], $
               [ 2778.26, 3481.74], $
               [ 3481.74, 4578.26], $
               [ 4578.26, 5681.74], $
               [ 5681.74, 7178.26], $
               [ 7178.26, 8941.74], $
               [ 8941.74, 11278.3]]

    IF N_ELEMENTS(e0) EQ 0 THEN e0=2
    IF N_ELEMENTS(e1) EQ 0 THEN e1=15

  ENDIF ELSE IF KEYWORD_SET(histp) OR STRPOS(inst,'HISTp') GE 0 THEN BEGIN

    IF STRPOS(inst,'HISTp') LT 0 THEN inst = 'HISTp'

    ch = [ [ 1000.00, 3000.00], $
               [ 3000.00, 3740.00], $
               [ 3740.00, 4650.00], $
               [ 4650.00, 5790.00], $
               [ 5790.00, 7210.00], $
               [ 7210.00, 8970.00], $
               [ 8970.00, 11170.0], $
               [ 11170.0, 13910.0], $
               [ 13910.0, 17320.0], $
               [ 17320.0, 21560.0], $
               [ 21560.0, 26850.0], $
               [ 26850.0, 33430.0], $
               [ 33430.0, 41620.0], $
               [ 41620.0, 51820.0], $
               [ 51820.0, 64510.0], $
               [ 64510.0, 80320.0]]

    IF N_ELEMENTS(e0) EQ 0 THEN e0=2
    IF N_ELEMENTS(e1) EQ 0 THEN e1=11

  ENDIF ELSE IF KEYWORD_SET(crres) OR STRPOS(inst,'CRRES') GE 0 THEN BEGIN

    IF STRPOS(inst,'CRRES') LT 0 THEN inst = 'CRRES'

    ch = [ [ 4000.,5000.], $
               [ 2500.00, 10000.00], $
               [ 1000.00, 1500.00], $
               [ 200.00, 300.00], $
               [ 10.00, 20.00], $
               [ 550.00, 650.00]]

    IF N_ELEMENTS(e0) EQ 0 THEN e0=0
    IF N_ELEMENTS(e1) EQ 0 THEN e1=5

  ENDIF ELSE BEGIN

    PRINT, 'No instrument specified'

    IF N_ELEMENTS(inst) EQ 0 THEN inst = 'UNKNOWN'

    ch = 0

    IF N_ELEMENTS(e0) EQ 0 THEN e0=0
    IF N_ELEMENTS(e1) EQ 0 THEN e1=0

  ENDELSE

  RETURN, ch

END