PRO lsh_image_plot, small_images, CUSPS=cusps, POSTSCRIPT=postscript, PORTRAIT=portrait, minimum = minimum, maximum=maximum, LCT=lct, sub_heading=sub_heading, DIV=div

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0

  ; get image dimensions

  n_energies = (SIZE(small_images.image))(1)
  n_lpoints  = (SIZE(small_images.image))(2)
  n_images   = N_ELEMENTS(small_images)

  ; test output device

  IF KEYWORD_SET(postscript) THEN BEGIN

    IF datatype(postscript) NE 'STR' THEN BEGIN
      file=PICKFILE(TITLE='Select file for POSTSCRIPT output',FILTER='*.ps', PATH=ies_get_dir('PS',/POLAR) )
    ENDIF ELSE file = postscript

    IF file EQ '' THEN BEGIN
      MESSAGE, 'No data file given', /CONT
      RETURN
    ENDIF

    ; check if has directory defined

    IF STRLEN(strip_dirname(file)) EQ STRLEN(file) THEN file = concat_dir(ies_get_dir('PS',/POLAR),file)

  ENDIF ELSE file = ''

  ; get cusp data

  IF KEYWORD_SET(cusps) THEN BEGIN

    RESTORE, '/disk2/carter/plasma/cusps/cusps.sav'

  ENDIF

  ; initialize

  !P.MULTI = 0
  !P.POSITION = 0

  ; get scale factor

  factor = (200/n_energies) > 1

  ; display images

  IF NOT KEYWORD_SET(minimum) THEN minimum = MIN(small_images.image)>1
  IF NOT KEYWORD_SET(maximum) THEN maximum = MAX(small_images.image)>1

  smin = ALOG(minimum)
  smax = ALOG(maximum)

  xplots = 5 ; 8
  yplots = 5 ; 8
  nplots = xplots*yplots

  FOR f = 0, n_images-1 DO BEGIN

    k = f MOD nplots

    IF k EQ 0 THEN BEGIN

      !P.CHARSIZE = 1.0

      IF KEYWORD_SET(postscript) THEN BEGIN

        IF f GT 0 THEN DEVICE,/CLOSE

        SET_PLOT, 'PS'

        ; check if landscape or portrait output required

        IF 1 THEN BEGIN
          DEVICE, /COLOR, BITS=8, FILE=file+STRTRIM(f/nplots,2)+'.ps', XOFFSET=0.6, YOFFSET=0.5, XSIZE=19.9, YSIZE=26.5, /PORTRAIT
        ENDIF ELSE BEGIN
          DEVICE, FILE=file+STRTRIM(f/nplots,2), BITS=8, /LANDSCAPE, /COLOR
        ENDELSE

        LOADCT, 39

      ENDIF ELSE BEGIN

        SET_PLOT, devname

        WINDOW, XSIZE=600, YSIZE=800, /FREE, RETAIN=2, TITLE='Plot '+STRTRIM(f/nplots,2)

        file = ''

      ENDELSE

      ; get character sizes in normal coords

      x_chsize = get_chsize(/X)
      y_chsize = get_chsize(/Y)

      ; do title

      heading = 'L shell versus energy plot'

      XYOUTS, 0.5 - STRLEN(heading)*x_chsize*1.5/2.0, 1-2*y_chsize, heading, CHARSIZE=1.5*!P.CHARSIZE, /NORMAL

      IF KEYWORD_SET(sub_heading) THEN $
        XYOUTS, 0.5 - STRLEN(sub_heading)*x_chsize*1.5/2.0, 1-4*y_chsize, sub_heading, $
              CHARSIZE=1.5*!P.CHARSIZE, /NORMAL

      ytop = 1-4.5*y_chsize

      ; do footnotes

      get_utc, utc

      footnote = 'Page '+STRTRIM(f/nplots+1,2)+' : ' + anytim2cal(utc, FORM=9)

      XYOUTS, 1.0 - STRLEN(footnote)*0.6*x_chsize, y_chsize*0.1, footnote, /NORMAL, CHARSIZE=0.6*!P.CHARSIZE

      footnote = strip_dirname(file)
      XYOUTS, 0.01, y_chsize*0.1, footnote, /NORMAL, CHARSIZE=0.6*!P.CHARSIZE

      ysiz = 0.8/yplots
      ytop = 1-4.3*y_chsize
      xsiz = (1-6*x_chsize)/xplots

      ; set plot region

      !P.REGION = [ 0.0, 0.0, 0.90, 0.1]

      ; define z title

      ; draw color bar

      ctitle = 'cts/s/cm2/sr'
      IF KEYWORD_SET(div) THEN ctitle = ctitle + '/keV'

      ies_do_xcolorbar, EXP(smin), EXP(smax), !D.N_COLORS, CTITLE=ctitle, /LOG

    ENDIF

    ; set plot region

    !P.REGION = [ 6*x_chsize+(k MOD xplots)*xsiz, ytop-ysiz*(k/yplots+1), 6*x_chsize+(k MOD xplots)*xsiz+xsiz, ytop-ysiz*(k/yplots)]

    ; set parameters for axis labels

    IF (k MOD xplots) EQ 0 THEN BEGIN

      ytitle = 'Lshell'
      ytickformat = ''

    ENDIF ELSE BEGIN

      ytitle = ''
      ytickformat = 'ies_noticks'

    ENDELSE

    IF (k+xplots) GE nplots THEN BEGIN

      xtitle = 'Energy bins'

      xtickformat = ''

    ENDIF ELSE BEGIN

      xtitle = ''
      xtickformat = 'ies_noticks'

    ENDELSE

    ; set up time

    IF ies_tag_exists(small_images,'LTIMES') THEN BEGIN
      title = anytim2cal(small_images(f).ltimes[0])
    ENDIF ELSE IF  ies_tag_exists(small_images,'TIME') THEN BEGIN
      title = anytim2cal(small_images(f).time)
    ENDIF ELSE title = ''

    ; set up axes
    ; cheat to avoid last tick name being written

    PLOT, [0,1], XSTYLE=1, YSTYLE=1, XRANGE=[0,n_energies], YRANGE=[0,n_lpoints/10.], $
                  /NODATA, TICKLEN=-0.02, /NOERASE, XMARGIN=[0,1],YMARGIN=[0,2.5], $
                  TITLE=title, XTITLE=xtitle, YTITLE=ytitle, $
                  XTICKFORMAT=xtickformat, YTICKFORMAT=ytickformat, CHARSIZE=0.8*4./xplots, $
                  XCHARSIZE=1.25*4./xplots, YCHARSIZE=1.25*4./yplots

    ; create image

    image = ALOG(small_images(f).image>minimum)

    IF smax-smin NE 0 THEN image = !d.n_colors*(image-smin)/(smax-smin)

    ; white out zero elements for postscript plot

;    IF !D.NAME EQ 'PS' THEN BEGIN

;      list = WHERE ( image EQ 0, count )

;      IF count GT 0 THEN image(list) = 255

;    ENDIF

    image = REBIN(image,factor*n_energies,n_lpoints,/SAMPLE)

    ; check if rescaleable output device

    IF !D.FLAGS AND 1 THEN BEGIN

      ; plot image

      TV, image, 0, 0, /DATA, XSIZE=n_energies, YSIZE=n_lpoints/10., ORDER=0

    ENDIF ELSE BEGIN

      ; get device coords of plot window

      vector = CONVERT_COORD ( !X.WINDOW, !Y.WINDOW, /NORMAL, /TO_DEVICE )

      ; get origin and size in device co-ords (inclusive of axes)

      xorig = vector(0,0)
      yorig = vector(1,0)
      xsize = FIX(vector(0,1) - xorig + 1)
      ysize = FIX(vector(1,1) - yorig + 1)

      ; check xsize and ysize are reasonable

      IF xsize LE 0 OR ysize LE 0 THEN BEGIN
        PRINT, 'IMAGE WINDOW INVALID SIZE :', title
        RETURN
      ENDIF

      ; plot image

      image = image(factor*n_energies*FINDGEN(xsize)/xsize,*)
      image = image (*,n_lpoints*FINDGEN(ysize)/ysize)

      TV, image, xorig, yorig, ORDER=0

      IF KEYWORD_SET(lct)THEN BEGIN

        xpos = 3
        FOR o = 0, (SIZE(lct))[1]-1 DO BEGIN
          XYOUTS, xorig+xpos, yorig+2, /DEVICE, STRING(lct[o,f].mlt MOD 24, FORMAT='(I2)'), $
            CHARSIZE=4./xplots, COLOR=254
          xpos = xpos + xsize/(SIZE(lct))[1]
        ENDFOR

    ENDIF

      ; TV, INTERPOLATE(vol(*,*,k), header.nsectors*FINDGEN(xsize)/xsize, $
      ;    header.ndetectors*FINDGEN(ysize)/ysize, /GRID), xorig, yorig, ORDER=0

    ENDELSE

    ; replot plot box axes to ensure they are visible

    PLOTS, [!X.WINDOW(0),!X.WINDOW(1),!X.WINDOW(1),!X.WINDOW(0),!X.WINDOW(0)], $
           [!Y.WINDOW(0),!Y.WINDOW(0),!Y.WINDOW(1),!Y.WINDOW(1),!Y.WINDOW(0)], $
           /NORMAL

  ENDFOR

  IF KEYWORD_SET(postscript) THEN BEGIN

    DEVICE,/CLOSE
    SET_PLOT, devname

  ENDIF

END