PRO lsh_mlat, xlsh, lpoints, struct, T0=t0, T1=t1

  ; come back out to top level

  ON_ERROR, 0 ; stay at error point

  LOADCT, 39

  IF NOT KEYWORD_SET(xlsh) THEN MESSAGE, 'No LSHELLs defined'

  ; process times

  IF KEYWORD_SET(t0) THEN BEGIN 

    tai = utc2tai(anytim2utc (t0))

    list = WHERE(xlsh[0,*].time_start GT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits after start time'
      RETURN
    ENDIF

    start_orbit = list[0]

  ENDIF ELSE start_orbit = 0

  IF KEYWORD_SET(t1) THEN BEGIN 

    tai = utc2tai(anytim2utc (t1))

    list = WHERE(xlsh[0,*].time_end LT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits before end time'
      RETURN
    ENDIF

    end_orbit = list[count-1]

  ENDIF ELSE end_orbit = (SIZE(xlsh))(2)-1

  ; set nparts 

  nparts = (SIZE(xlsh))[1]

  ; loop through orbits

  FOR o = start_orbit, end_orbit DO BEGIN

    ; process each part of the orbit

    FOR p = 0, nparts-1 DO BEGIN

      ; get data for this part of the orbit

      ephem = lsh_get_ephem( [xlsh[p,o].time_start, xlsh[p,o].time_end], NFP=nfp) 

      IF N_TAGS(ephem) GT 0 THEN BEGIN

        ; set no. of channels

        nchannels = 1

        ; check time monotonic increasing

        temp = WHERE ( ephem[1:*].time LT ephem.time, count)

        IF count NE 0 THEN MESSAGE, 'Time not monotonic increasing'
  
        ; set up output structure

        IF p EQ 0 AND o EQ start_orbit THEN BEGIN

          ; initialize arrays

          type = 'MLAT'
  
          IF NOT EXECUTE ( 'dstruct={' + type + '_LSH_'+STRTRIM(lpoints,2)+'_STRUCTURE,' + $
                       'time:DBLARR(lpoints+1),'+ $
                       'data:FLTARR(nchannels, lpoints) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'
                     
          struct = REPLICATE(dstruct,nparts,end_orbit-start_orbit+1)

        ENDIF

        tstruct = dstruct

        ; divide data into lshell intervals
        ; lose last point so need at least 2 points
            
        IF N_ELEMENTS(ephem) GT 1 THEN BEGIN

          lshells = ephem.l
          xtime = ephem.time
          xdata = ephem.mlat
          xpoints = N_ELEMENTS(ephem)

          ; lshells are lshell values of mid point of each sample
          ; last point gives lshell boundary of previous point -- data not used
          ; depending which part of orbit on these may increase or decrease with time
          ; get increasing l shell values -> lshells
          ; xtime are times of start points of each sample, may increase or decrease depending on orbit.

          IF lshells[0] GT lshells[xpoints-1] THEN BEGIN
            lshells = REVERSE(lshells)
            xtime   = REVERSE(xtime)         
            xdata   = REVERSE(xdata,2)
          ENDIF

          ; get new lshell sample points

          lvals = FINDGEN(lpoints+1)/10.0                    

          ; NB lshells now increasing

          list = WHERE(lshells LT lshells[1:*], count)

          IF count NE N_ELEMENTS(lshells)-1 THEN BEGIN

            ; lshells not strictly monotonic

            IF count LT 2 THEN MESSAGE, 'Insufficient lshells'

            lshells = lshells[list]
            xtime = xtime[list]
            xdata = xdata[*,list]
            xpoints = count

          ENDIF

          ; get times associated with lshell values for each new sample point        
          ; NB requires lshells monotonic

          tstruct.time = INTERPOL ( xtime, lshells, lvals)                 

          ; set times outside  of xtime values to last value

          tstruct.time = MAX(xtime) < tstruct.time > MIN(xtime)

          list = WHERE(lvals GE lshells[0] AND lvals LE lshells[xpoints-1], count)

          IF count GT 0 THEN tstruct.data[0,list] = INTERPOL(xdata,lshells,lvals[list])

          struct[p,o-start_orbit] = tstruct  
   
        ENDIF ELSE BEGIN ; npoints gt 1

          ; npoints le 1

          IF NOT KEYWORD_SET(struct) THEN MESSAGE, 'Invalid first data set'

          struct[p,o-start_orbit].data = 0
          struct[p,o-start_orbit].time = xlsh[p,o].time_start
          struct[p,o-start_orbit].time[lpoints] = xlsh[p,o].time_end

        ENDELSE

      ENDIF ELSE BEGIN; data available

        ; no data available

        PRINT,'No ephemeris data'

        IF NOT KEYWORD_SET(struct) THEN MESSAGE, 'Invalid first data set'

        struct[p,o-start_orbit].data = 0
        struct[p,o-start_orbit].time = xlsh[p,o].time_start
        struct[p,o-start_orbit].time[lpoints] = xlsh[p,o].time_end

      ENDELSE

    ENDFOR; loop over p

  ENDFOR; loop over o

END 