; found bug separating north and south

PRO lsh_mlt, samp, T0=t0, T1=t1, INST=inst, MODE=mode, SECTORS=sectors, $
             DETECTOR=detector, SHOW=show, REMOVE=remove, ORBIT_ONLY=orbit_only

  COMMON ies_draw_widget_block, input_header, input_data, header, data, $
           output_info, output_chans, output_array, ids, dnfull, dnscroll, files, ephem, mf, at

  ; come back out to top level

  ON_ERROR, 0 ; stay at error point

  LOADCT, 3

  IF KEYWORD_SET(show) THEN BEGIN
    !P.MULTI = [0,1,4,0,0]
    !P.REGION=0
    !P.POSITION=0
  ENDIF

  IF NOT KEYWORD_SET(samp) THEN BEGIN

    ; process times

    IF KEYWORD_SET(t0) THEN tai0 = utc2tai(anytim2utc(anytim2cal(t0,/DATE))) ELSE $
      tai0 = utc2tai(anytim2utc('97/01/01'))

    IF KEYWORD_SET(t1) THEN tai1 = utc2tai(anytim2utc(anytim2cal(t1,/DATE))) ELSE $
      tai1= utc2tai(anytim2utc('97/12/31'))

    ; default instrument to 'IES'

    IF NOT KEYWORD_SET(inst) THEN inst = 'IES'

    IF inst NE 'IES' AND inst NE 'HISTe' AND inst NE 'HISTp' AND inst NE 'IPS' THEN inst = 'IES'

    ; default detector to 0

    IF N_ELEMENTS(detector) EQ 0 THEN BEGIN
      IF STRPOS(inst,'HIST') GE 0 THEN detectors = [1] ELSE $
      IF STRPOS(inst,'IES') GE 0  THEN detectors = [1,1,1,1,1,1,1,1,1] ELSE $
      IF STRPOS(inst,'IPS') GE 0  THEN detectors = [0,0,1,1,1,1,1,0,0,0]
      element = FIX(TOTAL(detectors))
    ENDIF ELSE BEGIN
      IF STRPOS(inst,'HIST') GE 0 THEN detectors = INTARR(1) ELSE $
      IF STRPOS(inste,'IES') GE 0  THEN detectors = INTARR(9) ELSE $
      IF STRPOS(inste,'IPS') GE 0  THEN detectors = INTARR(10)
      element = 0
      detectors[detector < (N_ELEMENTS(detectors)-1)] = 1
    ENDELSE

    tim = tai0

    IF KEYWORD_SET(show) THEN str = '' ELSE str = 'g'

    WHILE tim LE tai1 DO BEGIN

      ; get data for this part of the orbit

      IF lsh_get_data( inst, detectors, [tim, tim+24.*3600.], REMOVE=remove, MODES=mode, EPHEM=eph) THEN BEGIN

        ; set up processing info

        output_info = {log:1, cal:1, div:1, rat:1, shift:0, subtract:0, track:1, $
          rng:0.0, button_labels:STRARR(12), button_values:[1,0,1,0,0,0,0,0,0,0,0,0], procname:'SPECTRAL', $
          full_only:0, full_detector:element, full_sector:0, axes:1, $
          band_labels:STRARR(20), noutputs:0, $
          format:'ENERGY vs DETECTOR', ptitle:STRARR(20), time:0.0D0, ysamples:0, elo:0.0, ehi:0.0, $
          minimum:1.e2, maximum:1.e8, elow:0.0, ehigh:0.0, min:0, max:0, elo:0, ehi:0 }


        ; process data

        IF ies_calibrate(/QUIET) THEN MESSAGE, 'ies_calibrate error'

        ; set no. of channels

        nchannels = header.nbands
        IF KEYWORD_SET(sectors) THEN nchannels = header.nsectors

        IF header.npoints GT 1 THEN BEGIN

          ; check if energy or sector info required

          IF KEYWORD_SET(sectors) THEN BEGIN

            ; energy average data

            start_chan = 0
            IF STRPOS(header.datatype,'HISTe') GE 0 THEN start_chan = 2 < header.nbands
            IF STRPOS(header.datatype,'IES') GE 0   THEN start_chan = 1 < header.nbands

            xdata = REFORM(TOTAL ( data.data(*,element,start_chan:*), 3 )) ; element ????

          ENDIF ELSE BEGIN

            xdata = REFORM(output_array[element,*,*])

          ENDELSE

          ; interpolate ephemeris data to get L shell values for each data sample

          times = (data[0:header.npoints-2].time+data[1:header.npoints-1].time)/2

          lshells = INTERPOL ( eph.l , eph.time, times)
          mlats   = INTERPOL ( eph.mlat, eph.time, times)
          mlts    = INTERPOL ( eph.edmlt, eph.time, times)

          ; lose last data point

          xdata = xdata[*,0:header.npoints-2]

          nbands = input_header.nbands

          ils = ACOS(SQRT(1./lshells))*180/!PI

          IF KEYWORD_SET(show) THEN BEGIN
            window, 0
            PLOT, lshells, yrange=[0,50], TITLE = 'Lsh'
            PLOT, mlats, yrange=[-90,90], TITLE = 'Mlat'
            PLOT, mlts, yrange=[0,24], TITLE = 'MLT'
            PLOT, ils, yrange=[0,90], TITLE = 'Ilat'
          ENDIF

          IF str NE 'g' AND str NE 'G' AND KEYWORD_SET(show) THEN BEGIN
            str = get_kbrd(1)
            IF str EQ 's' THEN STOP
          ENDIF

          ; set up array

          IF NOT KEYWORD_SET(samp) THEN BEGIN
            xbn = 180					; *** Define the size of the image array
            ybn = 180
            samp = FLTARR(xbn,ybn,1+nbands,2)		; *** Cumulative sampling array
          ENDIF

          ; *** Convert to bin numbers

          xb  = FIX( 2*(90.0-ils)*COS(mlts*!PI/12) + 90 )
          yb  = FIX( 2*(90.0-ils)*SIN(mlts*!PI/12) + 90 )

          ; clip

          list = WHERE( xb GE 0 AND xb LT xbn AND yb GE 0 AND yb LT ybn, count)

          IF count GT 0 THEN BEGIN

            xb = xb[list]
            yb = yb[list]
            IF NOT KEYWORD_SET(orbit_only) THEN data = xdata[*,list]
            mlats = mlats[list]

            ; NORTH

            list = WHERE (mlats GE 0, count)

            IF count GT 0 THEN BEGIN

              xxb = xb[list]
              yyb = yb[list]

              IF NOT KEYWORD_SET(orbit_only) THEN FOR kk = 0, count-1 DO $
                samp[xxb[kk],yyb[kk],1:*,0] = samp[xxb[kk],yyb[kk],1:*,0] + data[*,list[kk]]

              FOR kk = 0, count-1 DO samp[xxb[kk],yyb[kk],0,0] = samp[xxb[kk],yyb[kk],0,0] + 1

            ENDIF

            ; SOUTH

            list = WHERE (mlats LT 0, count)

            IF count GT 0 THEN BEGIN

              xxb = xb[list]
              yyb = yb[list]

              IF NOT KEYWORD_SET(orbit_only) THEN FOR kk = 0, count-1 DO $
                samp[xxb[kk],yyb[kk],1:*,1] = samp[xxb[kk],yyb[kk],1:*,1] + data[*,list[kk]]

              FOR kk = 0, count-1 DO samp[xxb[kk],yyb[kk],0,1] = samp[xxb[kk],yyb[kk],0,1] + 1

            ENDIF

          ENDIF

        ENDIF ; ephemeris data available

      ENDIF ; ok

      tim = utc2tai(anytim2utc(anytim2cal(tim+25.*3600.,/DATE)))

    ENDWHILE

    IF KEYWORD_SET(show) THEN !P.MULTI = 0

  ENDIF

END